﻿using System;
using System.Collections.Generic;
using CookComputing.XmlRpc;

namespace BTS.Trac
{
    /// <summary>
    /// XML-RPC 属性制御
    /// </summary>
    public class XmlRpcAttributes
    {
        /// <summary>
        /// XML-RPC パラメータ
        /// </summary>
        public XmlRpcStruct value
        {
            get;
            set;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public XmlRpcAttributes()
        {
            value = new XmlRpcStruct();
        }

        /// <summary>
        /// 属性を取得
        /// </summary>
        /// <typeparam name="T">値の型</typeparam>
        /// <param name="key">キー</param>
        /// <returns>値</returns>
        public T Get<T>( string key )
        {
            T result = default( T );
            if ( value.Contains( key ) && (value[key] is T) ) {
                result = (T)value[key];
            }

            return result;
        }

        /// <summary>
        /// 属性の設定
        /// </summary>
        /// <typeparam name="T">値の型</typeparam>
        /// <param name="key">キー</param>
        /// <param name="value">値</param>
        public void Set<T>( string key, T value )
        {
            this.value[key] = value;
        }
    }
}
