package sharin.unlinq.iterable;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class RangeIterable implements Iterable<Integer> {

    private final int start;

    private final int count;

    public RangeIterable(int start, int count) {
        this.count = count;
        this.start = start;
    }

    public Iterator<Integer> iterator() {

        return new Iterator<Integer>() {

            private int index;

            private int value = start;

            public boolean hasNext() {
                return index < count;
            }

            public Integer next() {

                if (index >= count) {
                    throw new NoSuchElementException();
                }

                index++;
                return value++;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}
