package sharin.sql.runner.processor;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

import sharin.sql.runner.ResultSetProcessor;
import sharin.util.SqlUtils;

public class ArrayResultSetProcessor implements ResultSetProcessor {

    public Integer prepare(ResultSet rs) {
        ResultSetMetaData metaData = SqlUtils.getMetaData(rs);
        return SqlUtils.getColumnCount(metaData);
    }

    public Object process(ResultSet rs, Object context) {
        int count = (Integer) context;
        Object[] result = new Object[count];

        for (int i = 0; i < count; i++) {
            result[i] = SqlUtils.getObject(rs, i + 1);
        }

        return result;
    }
}
