package sharin.sql.runner;

import java.util.List;

import sharin.sql.Sql;

public interface SqlRunner {

    public <R> R selectForObject(Sql sql);

    public <R> R selectForObject(Sql sql, ResultSetProcessor processor);

    public <R> List<R> selectForList(Sql sql);

    public <R> List<R> selectForList(Sql sql, ResultSetProcessor processor);

    public <R> List<R> selectForList(Sql sql, int limit, int offset);

    public <R> List<R> selectForList(Sql sql, int limit, int offset,
            ResultSetProcessor processor);

    public int insert(Sql sql);

    public <I> I insertForId(Sql sql);

    public <I> I insertForId(Sql sql, ResultSetProcessor processor);

    public int update(Sql sql);

    public int delete(Sql sql);

    public int execute(Sql sql);
}
