package sharin.doc.builder.xhtml1;

import sharin.doc.builder.Elem;

public class GenericCellElem<E extends Elem> extends GenericCommonElem<E> {

    public GenericCellElem(String name, Object... nodes) {
        super(name, nodes);
    }

    public E align(String value) {
        return attr("align", value);
    }

    public E alignLeft() {
        return align("left");
    }

    public E alignCenter() {
        return align("center");
    }

    public E alignRight() {
        return align("right");
    }

    public E alignJustify() {
        return align("justify");
    }

    public E alignChar() {
        return align("char");
    }

    /**
     * char
     */
    public E cha(String value) {
        return attr("char", value);
    }

    public E charoff(String value) {
        return attr("charoff", value);
    }

    public E valign(String value) {
        return attr("valign", value);
    }

    public E valignTop() {
        return valign("top");
    }

    public E valignMiddle() {
        return valign("middle");
    }

    public E valignBottom() {
        return valign("bottom");
    }

    public E valignBaseline() {
        return valign("baseline");
    }
}
