/*
 * Decompiled with CFR 0.152.
 */
package sharin.unlinq.iterable;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import sharin.unlinq.ConcatenatedIterator;
import sharin.unlinq.QueuedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionIterable<T>
implements Iterable<T> {
    private final Iterable<T> first;
    private final Iterable<T> second;

    public UnionIterable(Iterable<T> first, Iterable<T> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public Iterator<T> iterator() {
        return new QueuedIterator<T, T, T>(new ConcatenatedIterator<T>(this.first.iterator(), this.second)){
            private final Set<T> set;
            {
                this.set = new HashSet();
            }

            @Override
            protected void addElement(Queue<T> queue, T t) {
                if (!this.set.contains(t)) {
                    queue.add(t);
                    this.set.add(t);
                }
            }

            @Override
            protected T toResult(T e) {
                return e;
            }
        };
    }
}

