/*
 * Decompiled with CFR 0.152.
 */
package sharin.unlinq.iterable;

import java.util.Iterator;
import java.util.Queue;
import sharin.unlinq.Func;
import sharin.unlinq.QueuedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkipWhileIterable<T>
implements Iterable<T> {
    private final Iterable<T> iterable;
    private final Func<T, Boolean> predicate;

    public SkipWhileIterable(Iterable<T> iterable, Func<T, Boolean> predicate) {
        this.iterable = iterable;
        this.predicate = predicate;
    }

    @Override
    public Iterator<T> iterator() {
        return new QueuedIterator<T, T, T>(this.iterable.iterator()){
            private boolean skipped;

            @Override
            protected void addElement(Queue<T> queue, T t) {
                if (!this.skipped) {
                    if (((Boolean)SkipWhileIterable.this.predicate.call(t)).booleanValue()) {
                        return;
                    }
                    this.skipped = true;
                }
                queue.add(t);
            }

            @Override
            protected T toResult(T e) {
                return e;
            }
        };
    }
}

