/*
 * Decompiled with CFR 0.152.
 */
package sharin.unlinq.iterable;

import java.util.Iterator;
import java.util.Queue;
import sharin.unlinq.Enumerable;
import sharin.unlinq.Func;
import sharin.unlinq.Func2;
import sharin.unlinq.Pair;
import sharin.unlinq.QueuedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectManyIterable<T, C, R>
implements Iterable<R> {
    private final Iterable<T> iterable;
    private final Func2<T, C, R> resultSelector;
    private final Func<T, Enumerable<C>> collectionSelector;

    public SelectManyIterable(Iterable<T> iterable, Func2<T, C, R> resultSelector, Func<T, Enumerable<C>> collectionSelector) {
        this.iterable = iterable;
        this.resultSelector = resultSelector;
        this.collectionSelector = collectionSelector;
    }

    @Override
    public Iterator<R> iterator() {
        return new QueuedIterator<T, Pair<T, C>, R>(this.iterable.iterator()){

            @Override
            protected void addElement(Queue<Pair<T, C>> queue, T t) {
                for (Object c : (Enumerable)SelectManyIterable.this.collectionSelector.call(t)) {
                    queue.add(new Pair(t, c));
                }
            }

            @Override
            protected R toResult(Pair<T, C> e) {
                return SelectManyIterable.this.resultSelector.call(e.first, e.second);
            }
        };
    }
}

