/*
 * Decompiled with CFR 0.152.
 */
package sharin.unlinq;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueuedIterator<T, E, R>
implements Iterator<R> {
    private final Iterator<T> iterator;
    private Queue<E> queue = new LinkedList();

    public QueuedIterator(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    protected abstract void addElement(Queue<E> var1, T var2);

    protected abstract R toResult(E var1);

    @Override
    public boolean hasNext() {
        if (this.queue == null) {
            return false;
        }
        if (!this.queue.isEmpty()) {
            return true;
        }
        while (this.iterator.hasNext()) {
            this.addElement(this.queue, this.iterator.next());
            if (this.queue.isEmpty()) continue;
            return true;
        }
        this.queue = null;
        return false;
    }

    @Override
    public R next() {
        if (this.queue == null) {
            throw new NoSuchElementException();
        }
        if (this.queue.isEmpty() && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.toResult(this.queue.remove());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

