/*
 * Decompiled with CFR 0.152.
 */
package sharin.doc.builder;

import java.util.List;
import sharin.doc.builder.Attr;
import sharin.doc.builder.Elem;
import sharin.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericXmlElem<E extends Elem>
extends Elem {
    public GenericXmlElem(String name, Object ... nodes) {
        super(name, nodes);
    }

    public E attr(String name, Object value) {
        return (E)super.attr(name, value);
    }

    public E _(Object ... nodes) {
        return (E)super._(nodes);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        builder.append(StringUtils.escapeXml(this.getName()));
        for (Attr attr : this.getAttrList()) {
            builder.append(" ");
            builder.append(StringUtils.escapeXml(attr.getName()));
            builder.append("=\"");
            builder.append(StringUtils.escapeXml(String.valueOf(attr.getValue())));
            builder.append('\"');
        }
        List<Object> nodeList = this.getNodeList();
        if (nodeList.size() > 0) {
            builder.append(">");
            for (Object node : nodeList) {
                String s = node.toString();
                if (!(node instanceof Elem)) {
                    s = StringUtils.escapeXml(s);
                }
                builder.append(s);
            }
            builder.append("</");
            builder.append(StringUtils.escapeXml(this.getName()));
            builder.append(">");
        } else {
            builder.append(" />");
        }
        return builder.toString();
    }
}

