#ifndef PWD_H
#define PWD_H

#define gid_t int
#define uid_t int

struct passwd {
  char *pw_name;
  uid_t pw_uid;
  gid_t pw_gid;
  char *pw_dir;
  char *pw_shell;
};

extern struct passwd *getpwent (void);
extern void           setpwent (void);
extern void           endpwent (void);
extern struct passwd *getpwnam (const char *);
extern struct passwd *getpwuid (uid_t);
extern char          *getlogin (void);

#endif
