#define restrict __restrict

#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <windows.h>
#include <lmcons.h>

char *
getlogin (void)
{
  static char user_name[UNLEN+1];
  DWORD  length = sizeof (user_name);

  if (GetUserName (user_name, &length))
    return user_name;
  return NULL;
}

static struct passwd pwentry = {
  NULL, 0, 0, NULL, NULL
};

static int pw_count = 0;

struct passwd *
getpwent (void)
{
  if (!pwentry.pw_name)
    pwentry.pw_name = strdup (getlogin ());
  if (stricmp (pwentry.pw_name, "administrator") != 0)
    pwentry.pw_uid = 42;
  if (!pwentry.pw_dir)
    {
      char *home = getenv ("HOME");
      char *h;

      if (!home)
	home = "/";
      pwentry.pw_dir = strdup (home);
      for (h = pwentry.pw_dir; *h; h++)
	if (*h == '\\')
	  *h = '/';
    }
  if (!pwentry.pw_shell)
    {
      char *shell = getenv ("SHELL");
      char *s;

      if (!shell)
	shell = getenv ("ComSpec");
      if (!shell)
	shell = getenv ("COMSPEC");
      if (!shell)
	shell = "C:/WINDOWS/system32/cmd.exe";
      pwentry.pw_shell = strdup (shell);
      for (s = pwentry.pw_shell; *s; s++)
	if (*s == '\\')
	  *s = '/';
    }

  if (pw_count++ == 0)
    return &pwentry;
  return NULL;
}

void
setpwent (void)
{
  pw_count = 0;
}

void
endpwent (void)
{
  pw_count = 0;
}

struct passwd *
getpwnam (const char *name)
{
  char *user = getlogin ();

  if (strcmp (user, name))
    return NULL;
  setpwent ();
  return getpwent ();
}

struct passwd *
getpwuid (uid_t uid)
{
  (void) uid;
  setpwent ();
  return getpwent ();
}

uid_t
getuid (void)
{
  return 42;
}
