/*
 * Decompiled with CFR 0.152.
 */
package android.pkgpackage.installer;

import android.pkgpackage.installer.ConsoleWindow;
import android.pkgpackage.installer.Dialog;
import android.pkgpackage.installer.Functional;
import android.pkgpackage.installer.OSDetect;
import java.io.File;
import javafx.application.Application;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class AndroidPackageInstaller
extends Application {
    private static String filename;
    private static GridPane gridlayout;
    private Button filechooserbtn;
    private MenuBar menubar;
    private ImageView androidLogo;
    private Button checkDevices;
    private Button installbtn;
    private TextField filenameInput;

    public static void main(String[] args) {
        AndroidPackageInstaller.launch((String[])args);
    }

    public void start(final Stage window) {
        window.setTitle("Apk Installer v3.0");
        Scene mainScene = new Scene((Parent)this.layout(), 432.0, 254.0);
        window.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                event.consume();
                AndroidPackageInstaller.exit();
            }
        });
        this.filechooserbtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                FileChooser fileChooser = new FileChooser();
                FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Android Package files (*.apk)", new String[]{"*.apk"});
                fileChooser.getExtensionFilters().add((Object)extFilter);
                File file = fileChooser.showOpenDialog((Window)window);
                filename = file.toString();
                AndroidPackageInstaller.this.filenameInput.setText(filename);
            }
        });
        window.setResizable(false);
        window.setScene(mainScene);
        window.show();
    }

    public BorderPane layout() {
        BorderPane topContainer = new BorderPane();
        topContainer.setTop((Node)this.mainMenuBar());
        topContainer.setCenter((Node)this.title());
        return topContainer;
    }

    private VBox mainMenuBar() {
        VBox menuBarBox = new VBox();
        this.menubar = new MenuBar();
        Menu app_menu = new Menu("_App");
        Menu help = new Menu("_Help");
        Menu console = new Menu("_Console");
        MenuItem pre_req = new MenuItem("Pre-Requisite...");
        MenuItem exit = new MenuItem("Exit");
        MenuItem about = new MenuItem("About");
        MenuItem credits = new MenuItem("Credits");
        MenuItem howtouse = new MenuItem("How To use?");
        MenuItem osinfo = new MenuItem("OS Info");
        MenuItem openConsole = new MenuItem("Open Console");
        app_menu.getItems().add((Object)pre_req);
        app_menu.getItems().add((Object)new SeparatorMenuItem());
        app_menu.getItems().add((Object)exit);
        console.getItems().add((Object)openConsole);
        help.getItems().add((Object)about);
        help.getItems().add((Object)credits);
        help.getItems().add((Object)new SeparatorMenuItem());
        help.getItems().add((Object)howtouse);
        help.getItems().add((Object)osinfo);
        this.menubar.getMenus().addAll((Object[])new Menu[]{app_menu, help, console});
        menuBarBox.getChildren().addAll((Object[])new Node[]{this.menubar});
        AndroidPackageInstaller.menuHandlers(exit, pre_req, about, credits, howtouse, osinfo, openConsole);
        return menuBarBox;
    }

    private static void menuHandlers(MenuItem exit, MenuItem pre_req, MenuItem about, MenuItem credits, MenuItem howtouse, MenuItem osinfo, MenuItem openConsole) {
        exit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                AndroidPackageInstaller.exit();
            }
        });
        pre_req.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Dialog.showDialog("Pre-Requisite", Functional.pre);
            }
        });
        about.setOnAction(new EventHandler(){

            public void handle(Event event) {
                Dialog.showDialog("About", "\nAndroid Apk Installer v3.0\n\nThis software is written by SAI PRASAD\n\nThis app is released under\n Creative Commons Attribution-NonCommercial 4.0 International License\n\nThis is a simple Android package Installer.\nThis piece of software will help you to install apk files\nOn your android phone directly from your computer");
            }
        });
        credits.setOnAction(new EventHandler(){

            public void handle(Event event) {
                Dialog.showCredits();
            }
        });
        howtouse.setOnAction(new EventHandler(){

            public void handle(Event event) {
                Dialog.showDialog("How to use?", "I have designed this software from a layman point of view..\n\nFirst copy the file to the current software directory.\n And all you have to do is to enter the file name followed by .apk extension.\n This version also implements the FileChooser so you can always click on 'Choose Apk File' button to Browse for the desired apk file\nThen Click on the Install button..\nThat's it, rest the software will handle.\nMake sure Debugging mode is turned on in your phone..\nConnect one device at a time.");
            }
        });
        osinfo.setOnAction(new EventHandler(){

            public void handle(Event event) {
                OSDetect osdetection = new OSDetect();
                String SYSTEM_INFO = "The Following is the System Information\n\n" + osdetection.OSDetect();
                Dialog.showDialog("Operating System Info", SYSTEM_INFO);
            }
        });
        openConsole.setOnAction(new EventHandler(){

            public void handle(Event event) {
                ConsoleWindow console = new ConsoleWindow();
                console.startConsoleWindow();
            }
        });
    }

    private GridPane title() {
        GridPane gridPane = new GridPane();
        gridPane.setPadding(new Insets(10.0, 0.0, 0.0, 20.0));
        this.androidLogo = new ImageView(new Image(AndroidPackageInstaller.class.getResourceAsStream("anrdroid.JPG")));
        this.androidLogo.setFitWidth(75.0);
        this.androidLogo.setFitHeight(86.0);
        Label appTitle = new Label("Apk Installer v3.0");
        this.filenameInput = new TextField();
        this.filenameInput.setPromptText("Filename.apk");
        appTitle.setFont(new Font("Algerian", 25.0));
        appTitle.setPadding(new Insets(0.0, 5.0, 0.0, 8.0));
        this.filechooserbtn = new Button("Choose Apk File");
        this.checkDevices = new Button("Show Connected Devices");
        this.installbtn = new Button("Install Apk");
        this.installbtn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                filename = AndroidPackageInstaller.this.filenameInput.getText();
                Functional.setFilename(filename);
                String output = Functional.performInstall();
                ConsoleWindow installwindow = new ConsoleWindow();
                installwindow.outputTxt = output;
                installwindow.startConsoleWindow();
                installwindow.output.setText(installwindow.outputTxt);
            }
        });
        this.checkDevices.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                ConsoleWindow con = new ConsoleWindow();
                con.startConsoleWindow();
                con.showConnectedDevices();
            }
        });
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        GridPane.setConstraints((Node)this.androidLogo, (int)0, (int)0);
        GridPane.setHalignment((Node)this.androidLogo, (HPos)HPos.CENTER);
        GridPane.setConstraints((Node)appTitle, (int)1, (int)0);
        GridPane.setConstraints((Node)this.filenameInput, (int)0, (int)1);
        GridPane.setConstraints((Node)this.filechooserbtn, (int)1, (int)1);
        gridPane.setVgap(20.0);
        GridPane.setConstraints((Node)this.installbtn, (int)0, (int)2);
        GridPane.setHalignment((Node)this.installbtn, (HPos)HPos.CENTER);
        GridPane.setConstraints((Node)this.checkDevices, (int)1, (int)2);
        gridPane.getChildren().addAll((Object[])new Node[]{this.androidLogo, appTitle, this.filenameInput, this.filechooserbtn, this.installbtn, this.checkDevices});
        return gridPane;
    }

    static void exit() {
        boolean option = Dialog.show_YES_NO_Dialog("Are you sure?", "Are you sure you want to exit? Ensure your work is done.");
        if (option) {
            System.exit(0);
        }
    }
}

