/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import snaq.util.LogUtil;
import snaq.util.ObjectPoolEvent;
import snaq.util.ObjectPoolListener;
import snaq.util.Reusable;
import snaq.util.TimeWrapper;

public abstract class ObjectPool
extends LogUtil {
    private static final int ACCESS_FIFO = 1;
    private static final int ACCESS_LIFO = 2;
    private static final int ACCESS_RANDOM = 3;
    private int accessMethod = 2;
    private String name;
    private List free;
    private List used;
    private int poolSize;
    private int maxSize;
    private long expiryTime;
    private long requests;
    private long hits;
    private boolean released = false;
    private boolean asyncDestroy = false;
    private DateFormat dateFormat;
    private Cleaner cleaner;
    private InitThread initer;
    private static int cleanerCount = 0;
    private List listeners = new ArrayList();
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$ArrayList;

    protected ObjectPool(String string, int n, int n2, long l) {
        Class clazz = this.getPoolClass();
        if (!(class$java$util$List == null ? (class$java$util$List = ObjectPool.class$("java.util.List")) : class$java$util$List).isAssignableFrom(clazz)) {
            throw new RuntimeException("Invalid pool class type specified: " + clazz.getName() + " (must implement java.util.List)");
        }
        try {
            this.free = (List)clazz.newInstance();
            this.used = (List)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to instantiate pool class type: " + clazz.getName());
        }
        this.name = string;
        this.setParameters(n, n2, l);
    }

    protected ObjectPool(String string, int n, int n2, int n3) {
        this(string, n, n2, (long)n3);
    }

    public final void init(int n) {
        if (n == 0) {
            return;
        }
        if (n > 0 && n <= this.getMaxSize()) {
            if (this.initer != null) {
                this.initer.halt();
                try {
                    this.initer.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid number of items specified for initialization");
        }
        this.initer = new InitThread(n);
        this.initer.start();
    }

    protected final synchronized Reusable checkOut() throws Exception {
        boolean bl;
        if (this.released) {
            throw new RuntimeException("Pool no longer valid for use");
        }
        int n = this.used.size() + this.free.size();
        TimeWrapper timeWrapper = null;
        Reusable reusable = null;
        if (this.free.size() > 0) {
            switch (this.accessMethod) {
                case 1: {
                    timeWrapper = (TimeWrapper)this.free.remove(0);
                    break;
                }
                case 3: {
                    timeWrapper = (TimeWrapper)this.free.remove((int)((double)this.free.size() * Math.random()));
                    break;
                }
                default: {
                    timeWrapper = (TimeWrapper)this.free.remove(this.free.size() - 1);
                }
            }
            reusable = (Reusable)timeWrapper.getObject();
            bl = this.isValid(reusable);
            while (!bl && this.free.size() > 0) {
                this.destroyObject(reusable);
                this.log("Removed invalid item from pool");
                timeWrapper = (TimeWrapper)this.free.remove(0);
                reusable = (Reusable)timeWrapper.getObject();
                bl = this.isValid(reusable);
            }
            if (this.free.size() == 0 && !bl) {
                reusable = null;
            }
        }
        boolean bl2 = bl = reusable != null;
        if (reusable == null) {
            if (this.maxSize > 0 && this.used.size() == this.maxSize) {
                this.fireMaxSizeLimitErrorEvent();
            } else if (!(this.used.size() >= this.maxSize && this.maxSize != 0 || this.isValid(reusable = this.create()))) {
                throw new RuntimeException("Unable to create a valid connection");
            }
        }
        if (reusable != null) {
            this.used.add(reusable);
            ++this.requests;
            if (bl) {
                ++this.hits;
            }
            this.firePoolCheckOutEvent();
            int n2 = this.used.size() + this.free.size();
            if (n2 == this.poolSize && n2 > n) {
                this.fireMaxPoolLimitReachedEvent();
            } else if (n2 == this.poolSize + 1 && n2 > n) {
                this.fireMaxPoolLimitExceededEvent();
            }
            if (n2 == this.maxSize && n2 > n) {
                this.fireMaxSizeLimitReachedEvent();
            }
        }
        if (this.debug) {
            String string = this.used.size() + "/" + (this.used.size() + this.free.size());
            String string2 = " (HitRate=" + this.getHitRate() + "%)";
            this.log("Checkout - " + string + string2 + (reusable == null ? " - null returned" : ""));
        }
        return reusable;
    }

    protected final synchronized Reusable checkOut(long l) throws Exception {
        long l2 = System.currentTimeMillis();
        Reusable reusable = null;
        reusable = this.checkOut();
        while (reusable == null && System.currentTimeMillis() - l2 < l) {
            try {
                if (this.debug) {
                    this.log("No pooled items spare...waiting for up to " + l + "ms");
                }
                this.wait(l);
                reusable = this.checkOut();
            }
            catch (InterruptedException interruptedException) {
                this.log(interruptedException, "Connection checkout interrupted");
            }
        }
        return reusable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkIn(Reusable reusable) {
        if (reusable == null) {
            this.log("Attempt to return null item");
            return;
        }
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            this.firePoolCheckInEvent();
            if (!this.used.remove(reusable)) {
                this.log("Attempt to return item not belonging to pool");
                throw new RuntimeException("Attempt to return item not belonging to pool " + this.name);
            }
            boolean bl = this.maxSize > 0 && this.free.size() + this.used.size() >= this.poolSize;
            boolean bl2 = bl = bl || this.maxSize == 0 && this.free.size() >= this.poolSize;
            if (bl) {
                this.destroyObject(reusable);
                if (this.debug) {
                    this.log("Checkin* - " + this.used.size() + "/" + (this.used.size() + this.free.size()));
                }
            } else {
                try {
                    reusable.recycle();
                    this.free.add(new TimeWrapper(null, reusable, this.expiryTime));
                    if (this.debug) {
                        this.log("Checkin  - " + this.used.size() + "/" + (this.used.size() + this.free.size()));
                    }
                    this.notifyAll();
                }
                catch (Exception exception) {
                    this.destroyObject(reusable);
                    this.log(exception, "Unable to recycle item - destroyed");
                }
            }
        }
    }

    public final void release() {
        this.release(false);
    }

    public final synchronized void releaseAsync() {
        this.releaseAsync(false);
    }

    public final void releaseForcibly() {
        this.release(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void release(boolean bl) {
        if (this.released) {
            return;
        }
        this.released = true;
        if (this.cleaner != null) {
            this.cleaner.halt();
            try {
                this.cleaner.join();
            }
            catch (InterruptedException interruptedException) {
                this.log(interruptedException, "Interrupted during halting of old cleaner thread");
            }
            this.cleaner = null;
        }
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            Object object;
            int n = 0;
            int n2 = 0;
            TimeWrapper timeWrapper = null;
            Reusable reusable = null;
            if (bl) {
                object = this.used.iterator();
                while (object.hasNext()) {
                    reusable = (Reusable)object.next();
                    try {
                        this.destroy(reusable);
                        ++n;
                    }
                    catch (Exception exception) {
                        ++n2;
                        this.log(exception, "Unable to release item in pool");
                    }
                }
                this.used.clear();
            } else {
                if (this.debug && this.used.size() > 0) {
                    this.log("Waiting for used items to be checked-in...");
                }
                while (this.used.size() > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            object = this.free.iterator();
            while (object.hasNext()) {
                timeWrapper = (TimeWrapper)object.next();
                reusable = (Reusable)timeWrapper.getObject();
                try {
                    this.destroy(reusable);
                    ++n;
                }
                catch (Exception exception) {
                    ++n2;
                    this.log(exception, "Unable to release item in pool");
                }
            }
            this.free.clear();
            if (this.debug) {
                object = "Released " + n + (n > 1 ? " items" : " item");
                if (n2 > 0) {
                    object = (String)object + " (failed to release " + n2 + (n2 > 1 ? " items)" : " item)");
                }
                this.log((String)object);
            }
            this.firePoolReleasedEvent();
            this.listeners.clear();
            super.close();
        }
    }

    private final void releaseAsync(final boolean bl) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ObjectPool.this.release(bl);
            }
        });
        thread.start();
    }

    protected abstract Reusable create() throws Exception;

    protected abstract boolean isValid(Reusable var1);

    protected abstract void destroy(Reusable var1);

    private final void destroyObject(final Reusable reusable) {
        if (reusable == null) {
            return;
        }
        if (this.asyncDestroy) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    ObjectPool.this.destroy(reusable);
                }
            });
            thread.start();
        } else {
            this.destroy(reusable);
        }
    }

    public final void setAsyncDestroy(boolean bl) {
        this.asyncDestroy = bl;
    }

    public final boolean isAsyncDestroy() {
        return this.asyncDestroy;
    }

    public void log(String string) {
        this.log(this.name + ": ", string);
    }

    public void log(Throwable throwable, String string) {
        this.log(throwable, this.name + ": ", string);
    }

    public final String getName() {
        return this.name;
    }

    public final int getPoolSize() {
        return this.poolSize;
    }

    public final int getMaxSize() {
        return this.maxSize;
    }

    public final long getExpiryTime() {
        return this.expiryTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setParameters(int n, int n2, long l) {
        Object object = this;
        synchronized (object) {
            if (this.cleaner != null) {
                this.cleaner.halt();
            }
            this.poolSize = Math.max(n, 0);
            this.maxSize = Math.max(n2, 0);
            this.expiryTime = Math.max(l, 0L);
            if (this.maxSize > 0 && this.maxSize < this.poolSize) {
                this.maxSize = this.poolSize;
            }
            this.resetHitCounter();
            TimeWrapper timeWrapper = null;
            Iterator iterator = this.free.iterator();
            while (iterator.hasNext()) {
                timeWrapper = (TimeWrapper)iterator.next();
                timeWrapper.setLiveTime(l);
            }
            if (this.expiryTime > 0L) {
                long l2 = Math.min(5000L, this.expiryTime / 5L);
                this.cleaner = new Cleaner(this, l2);
                this.cleaner.start();
            }
        }
        if (this.debug) {
            object = "pool=" + this.poolSize + ",max=" + this.maxSize + ",expiry=";
            object = (String)object + (this.expiryTime == 0L ? "none" : this.expiryTime + "ms");
            this.log("Parameters changed (" + (String)object + ")");
        }
        this.fireParametersChangedEvent();
    }

    public final synchronized int getSize() {
        return this.free.size() + this.used.size();
    }

    public final synchronized int getCheckedOut() {
        return this.used.size();
    }

    public final synchronized int getFreeCount() {
        return this.free.size();
    }

    public final float getHitRate() {
        return this.requests == 0L ? 0.0f : (float)this.hits / (float)this.requests * 100.0f;
    }

    protected final void resetHitCounter() {
        this.hits = 0L;
        this.requests = 0L;
    }

    protected final void setAccessFIFO() {
        this.accessMethod = 1;
    }

    protected final void setAccessLIFO() {
        this.accessMethod = 2;
    }

    protected final void setAccessRandom() {
        this.accessMethod = 3;
    }

    protected Class getPoolClass() {
        return class$java$util$ArrayList == null ? (class$java$util$ArrayList = ObjectPool.class$("java.util.ArrayList")) : class$java$util$ArrayList;
    }

    public void finalize() {
        if (this.cleaner != null) {
            this.cleaner.halt();
            this.cleaner = null;
        }
        if (this.initer != null) {
            this.initer.halt();
            this.initer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void flush() {
        int n = 0;
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            TimeWrapper timeWrapper = null;
            Iterator iterator = this.free.iterator();
            while (iterator.hasNext()) {
                timeWrapper = (TimeWrapper)iterator.next();
                iterator.remove();
                this.destroyObject((Reusable)timeWrapper.getObject());
                ++n;
            }
        }
        if (n > 0 && this.debug) {
            this.log("Flushed all spare items from pool");
        }
    }

    final synchronized boolean purge() {
        if (this.debug) {
            this.log("Checking for expired items");
        }
        int n = 0;
        TimeWrapper timeWrapper = null;
        Iterator iterator = this.free.iterator();
        while (iterator.hasNext()) {
            timeWrapper = (TimeWrapper)iterator.next();
            if (!timeWrapper.isExpired()) continue;
            iterator.remove();
            this.destroyObject((Reusable)timeWrapper.getObject());
            ++n;
        }
        return this.free.size() > 0 || n > 0;
    }

    public final void addObjectPoolListener(ObjectPoolListener objectPoolListener) {
        this.listeners.add(objectPoolListener);
    }

    public final void removeObjectPoolListener(ObjectPoolListener objectPoolListener) {
        this.listeners.remove(objectPoolListener);
    }

    private final void firePoolCheckOutEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent objectPoolEvent = new ObjectPoolEvent(this, 1);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ObjectPoolListener)iterator.next()).poolCheckOut(objectPoolEvent);
        }
    }

    private final void firePoolCheckInEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent objectPoolEvent = new ObjectPoolEvent(this, 2);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ObjectPoolListener)iterator.next()).poolCheckIn(objectPoolEvent);
        }
    }

    private final void fireMaxPoolLimitReachedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent objectPoolEvent = new ObjectPoolEvent(this, 3);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ObjectPoolListener)iterator.next()).maxPoolLimitReached(objectPoolEvent);
        }
    }

    private final void fireMaxPoolLimitExceededEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent objectPoolEvent = new ObjectPoolEvent(this, 4);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ObjectPoolListener)iterator.next()).maxPoolLimitExceeded(objectPoolEvent);
        }
    }

    private final void fireMaxSizeLimitReachedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent objectPoolEvent = new ObjectPoolEvent(this, 5);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ObjectPoolListener)iterator.next()).maxSizeLimitReached(objectPoolEvent);
        }
    }

    private final void fireMaxSizeLimitErrorEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent objectPoolEvent = new ObjectPoolEvent(this, 6);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ObjectPoolListener)iterator.next()).maxSizeLimitError(objectPoolEvent);
        }
    }

    private final void fireParametersChangedEvent() {
        if (this.listeners == null || this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent objectPoolEvent = new ObjectPoolEvent(this, 7);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ObjectPoolListener)iterator.next()).poolParametersChanged(objectPoolEvent);
        }
    }

    private final void firePoolReleasedEvent() {
        if (this.listeners.isEmpty()) {
            return;
        }
        ObjectPoolEvent objectPoolEvent = new ObjectPoolEvent(this, 8);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((ObjectPoolListener)iterator.next()).poolReleased(objectPoolEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class InitThread
    extends Thread {
        private int num;
        private boolean stopped = false;

        private InitThread(int n) {
            this.num = Math.min(ObjectPool.this.poolSize, Math.max(n, 0));
        }

        public void halt() {
            this.stopped = true;
        }

        public void run() {
            if (this.num > 0 && this.num <= ObjectPool.this.poolSize && ObjectPool.this.getSize() < this.num) {
                int n = 0;
                while (!this.stopped && ObjectPool.this.getSize() < this.num && this.num <= ObjectPool.this.poolSize) {
                    try {
                        Reusable reusable = ObjectPool.this.create();
                        if (reusable == null) {
                            throw new RuntimeException("Null item created");
                        }
                        ObjectPool.this.free.add(new TimeWrapper(null, reusable, ObjectPool.this.expiryTime));
                        ++n;
                        if (!ObjectPool.this.debug) continue;
                        ObjectPool.this.log("Initialized new item in pool");
                    }
                    catch (Exception exception) {
                        ObjectPool.this.log(exception, "Unable to initialize items in pool");
                        this.stopped = true;
                    }
                }
                if (ObjectPool.this.debug) {
                    ObjectPool.this.log("Initialized pool with " + n + " new item" + (n > 1 ? "s" : ""));
                }
            }
        }
    }

    final class Cleaner
    extends Thread {
        private ObjectPool pool;
        private long interval;
        private boolean stopped;

        Cleaner(ObjectPool objectPool2, long l) {
            this.setName("CleanerThread_" + Integer.toString(cleanerCount++));
            this.pool = objectPool2;
            this.interval = l;
        }

        public void start() {
            this.stopped = false;
            super.start();
        }

        public void halt() {
            if (!this.isHalted()) {
                this.stopped = true;
                this.interrupt();
            }
        }

        public boolean isHalted() {
            return this.stopped;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.pool.cleaner == Thread.currentThread() && !this.stopped) {
                ObjectPool objectPool = this.pool;
                synchronized (objectPool) {
                    if (!this.pool.purge()) {
                        try {
                            this.pool.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.stopped) continue;
                try {
                    Cleaner.sleep(this.interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

