/*
 * Decompiled with CFR 0.152.
 */
package venue;

import attendance.ActivityListDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import member.Member;
import member.MemberGroup;
import member.MemberGroupMember;
import system.Config;
import system.Lang;
import system.MasterCode;
import system.SystemCode;
import system.User;
import ui.AutoComboBoxNV;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.DatePicker;
import ui.DateTextField;
import ui.ScrollList2;
import ui.TableLayout;
import ui.TimeTextField;
import util.ComparableHashMap;
import util.RecordList;
import util.TimeUtil;
import util.Tools;
import util.Validation;
import util.WinUtil;
import venue.Venue;
import venue.VenueEquipment;
import venue.VenueRequest;
import venue.VenueRequestEquipment;
import venue.VenueRequestListDialog;

public class VenueRequestInfoDialog
extends DataDialog {
    private ComboBoxNV venueNV;
    private ComboBoxCN statusCN;
    private DatePicker dateDP;
    private TimeTextField start_timeTT;
    private TimeTextField end_timeTT;
    private ComboBoxNV member_groupNV;
    private ComboBoxCN purposeCN;
    private JTextField remarkTF;
    private JTextField user_numTF;
    private JTextField max_userTF;
    private AutoComboBoxNV memberNV;
    private DateTextField entry_dateDT;
    private ComboBoxNV add_equipment_idNV;
    private ScrollList2 itemSL;
    private JButton add_itemB;
    private JButton del_itemB;
    private JButton saveB;
    private JButton cancelB;
    private VenueRequest g_VenueRequest = null;
    private RecordList g_Items;
    private boolean g_IsUpdate = false;
    private boolean g_IsAddFromActivity = false;
    private ArrayList g_ActivityDates;

    public VenueRequestInfoDialog(DataDialog f, int venue_request_seq, boolean isUpdate) {
        super(f, "\u65b0\u589e\u5834\u5730\u7533\u8acb", false);
        if (isUpdate) {
            this.setTitle("\u4fee\u6539\u5834\u5730\u7533\u8acb");
        }
        this.g_IsUpdate = isUpdate;
        this.g_VenueRequest = new VenueRequest(venue_request_seq);
        VenueRequestEquipment p = new VenueRequestEquipment(venue_request_seq);
        this.g_Items = p.getItems();
        if (!this.g_IsUpdate && venue_request_seq != -1) {
            this.g_VenueRequest.resetForCopy();
        }
        this.initLayout();
    }

    public VenueRequestInfoDialog(DataDialog f, int venue_seq, int member_seq, ArrayList dates, String start_time, String end_time, int member_group_seq) {
        super(f, "\u65b0\u589e\u5834\u5730\u7533\u8acb", false);
        this.g_IsAddFromActivity = true;
        this.g_ActivityDates = dates;
        this.g_VenueRequest = new VenueRequest(-1);
        VenueRequestEquipment p = new VenueRequestEquipment(-1);
        this.g_Items = p.getItems();
        this.g_VenueRequest.newFromActivity(venue_seq, member_seq, TimeUtil.getDateByString((String)dates.get(0), start_time), TimeUtil.getDateByString((String)dates.get(0), end_time), member_group_seq, new Venue(venue_seq).getUser_capacity());
        this.initLayout();
    }

    private void initLayout() {
        this.setEditLayout();
        this.refreshEquipmentsMaxAvailQty();
        this.setEventHandler();
        this.setVisible(true);
    }

    private void setEditLayout() {
        this.venueNV = new ComboBoxNV((ArrayList)Venue.getVenueNames(), "name", "venue_seq", this.g_VenueRequest.getVenue_seq());
        this.statusCN = this.getStatusSel();
        this.dateDP = new DatePicker(this, this.g_VenueRequest.getStart_time(), !this.g_IsUpdate || this.g_IsAddFromActivity);
        if (this.g_IsAddFromActivity) {
            this.dateDP.setSelectedDates(this.g_ActivityDates);
        }
        this.start_timeTT = new TimeTextField(this.g_VenueRequest.getStart_time());
        this.end_timeTT = new TimeTextField(this.g_VenueRequest.getEnd_time());
        RecordList mg = MemberGroup.getGroupNames(MemberGroup.getAllActiveGroups(this.g_VenueRequest.getMember_group_seq()), "name", "member_group_seq");
        this.member_groupNV = new ComboBoxNV((ArrayList)mg, "name", "member_group_seq", this.g_VenueRequest.getMember_group_seq());
        this.purposeCN = new ComboBoxCN(MasterCode.getCodes("VENUE_REQUEST_PURPOSE"), this.g_VenueRequest.getPurpose());
        this.remarkTF = new JTextField(this.g_VenueRequest.getRemark());
        this.user_numTF = new JTextField(String.valueOf(this.g_VenueRequest.getUser_num()));
        this.max_userTF = new JTextField(String.valueOf(new Venue(this.g_VenueRequest.getVenue_seq()).getUser_capacity()));
        this.max_userTF.setEnabled(false);
        this.memberNV = new AutoComboBoxNV((ArrayList)MemberGroupMember.getActiveMembersInGroup(MemberGroup.ROOT_GROUP_SEQ, this.g_VenueRequest.getMember_seq()), Member.DISPLAY_NAME, "member_seq", this.g_VenueRequest.getMember_seq());
        this.entry_dateDT = new DateTextField(this.g_VenueRequest.getEntry_date() == null ? TimeUtil.getCurrentDate() : this.g_VenueRequest.getEntry_date());
        this.add_equipment_idNV = new ComboBoxNV((ArrayList)VenueRequest.getVenueEquipments(this.g_VenueRequest.getVenue_seq()), "name", "venue_equipment_seq", -1);
        this.add_itemB = new JButton("\u52a0\u5165\u8a2d\u5099");
        this.del_itemB = new JButton("\u522a\u9664\u8a2d\u5099");
        this.saveB = new JButton("\u78ba\u5b9a");
        this.cancelB = new JButton("\u53d6\u6d88");
        this.saveB.setEnabled(this.isSaveEnabled());
        TableLayout t = new TableLayout(this, 600, 600, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 250;
        nArray[2] = 130;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30, 30, 30, 30, 30});
        int row = 0;
        JLabel jLabel = new JLabel("\u5834\u5730");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, row, 1, 0);
        t.getClass();
        t.addCell(this.venueNV, 1, row, 20, 0);
        JLabel jLabel2 = new JLabel("\u73fe\u6cc1");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 2, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.statusCN, 3, row, 20, 0, 75, -1);
        ++row;
        JLabel jLabel3 = new JLabel("\u4f7f\u7528\u65e5\u671f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.dateDP, 1, row, 20, 0, 100, -1);
        t.getClass();
        t.addCell(this.start_timeTT, 1, row, 125, 0);
        JLabel jLabel4 = new JLabel("\u81f3");
        t.getClass();
        t.addCell(jLabel4, 1, row, 175, 0);
        t.getClass();
        t.addCell(this.end_timeTT, 1, row, 195, 0);
        ++row;
        JLabel jLabel5 = new JLabel("\u4f7f\u7528\u7fa4\u7d44");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.member_groupNV, 1, row, 20, 0, 200, -1);
        ++row;
        JLabel jLabel6 = new JLabel("\u4f7f\u7528\u4eba\u6578");
        t.getClass();
        t.getClass();
        t.addCell(jLabel6, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.user_numTF, 1, row, 20, 0, 50, -1);
        JLabel jLabel7 = new JLabel("\u4eba");
        t.getClass();
        t.addCell(jLabel7, 1, row, 70, 0);
        JLabel jLabel8 = new JLabel("(\u53ef\u5bb9\u7d0d");
        t.getClass();
        t.addCell(jLabel8, 1, row, 100, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.max_userTF, 1, row, 170, 0, 50, -1);
        JLabel jLabel9 = new JLabel("\u4eba)");
        t.getClass();
        t.addCell(jLabel9, 1, row, 220, 0);
        ++row;
        JLabel jLabel10 = new JLabel("\u7528\u9014");
        t.getClass();
        t.getClass();
        t.addCell(jLabel10, 0, row, 1, 0);
        t.getClass();
        t.addCell(this.purposeCN, 1, row, 20, 0);
        JLabel jLabel11 = new JLabel("\u7533\u8acb\u65e5\u671f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel11, 2, row, 1, 0);
        t.getClass();
        t.addCell(this.entry_dateDT, 3, row, 20, 0);
        ++row;
        JLabel jLabel12 = new JLabel("\u7533\u8acb\u4eba");
        t.getClass();
        t.getClass();
        t.addCell(jLabel12, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.memberNV, 1, row, 20, 0, 460, -1);
        ++row;
        JLabel jLabel13 = new JLabel("\u5099\u8a3b");
        t.getClass();
        t.getClass();
        t.addCell(jLabel13, 0, row, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.remarkTF, 1, row, 20, 0, 460, -1);
        ++row;
        JLabel jLabel14 = new JLabel("\u4f7f\u7528\u8a2d\u5099");
        t.getClass();
        t.getClass();
        t.addCell(jLabel14, 0, row, 1, 0);
        t.getClass();
        t.addCell(this.add_equipment_idNV, 1, row, 20, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.add_itemB, 2, row, 1, 0);
        t.getClass();
        t.addCell(this.del_itemB, 3, row, 20, 0);
        boolean[] blArray = new boolean[4];
        blArray[2] = true;
        this.itemSL = new ScrollList2(560, 250, this.g_Items, new int[]{300, 80, 80, 80}, new String[]{"\u8a2d\u5099\u540d\u7a31", "\u7e3d\u53ef\u7528\u91cf", "\u6578\u91cf", "\u55ae\u4f4d"}, new String[]{VenueEquipment.NAME, "max_qty", VenueRequestEquipment.QTY, VenueEquipment.UNIT}, blArray);
        this.itemSL.setEditing_mode(true);
        this.itemSL.setBigDecimalTextFieldColumn("max_qty", "#,##0.##");
        this.itemSL.setBigDecimalTextFieldColumn(VenueRequestEquipment.QTY, "0.##");
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{250});
        t.getClass();
        t.getClass();
        t.addCell(this.itemSL, 0, 0, 0, 0);
        t.addYSpace(15);
        t.addTable(new int[]{435, 70, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 1, 0, -1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    private ComboBoxCN getStatusSel() {
        String[] wa = Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__WA);
        String[] ap = Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__AP);
        String[] cl = Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__CL);
        String[] rj = Tools.getStatusItem(VenueRequest.STATUS_MAP, VenueRequest.STATUS__RJ);
        int cur_privilege = User.hasPrivilege("venueRequestApprove") ? 1 : 0;
        int cur_status = 0;
        if (this.g_VenueRequest.getStatus().isEmpty()) {
            cur_status = 0;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__WA)) {
            cur_status = 1;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__AP)) {
            cur_status = 2;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__CL)) {
            cur_status = 3;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__RJ)) {
            cur_status = 4;
        }
        Object[][] smatrix = new Object[2][5];
        smatrix[0][0] = new String[][]{wa};
        smatrix[0][1] = new String[][]{wa, cl};
        smatrix[0][2] = new String[][]{ap};
        smatrix[0][3] = new String[][]{cl};
        smatrix[0][4] = new String[][]{rj};
        smatrix[1][0] = new String[][]{wa, ap};
        smatrix[1][1] = new String[][]{wa, ap, cl, rj};
        smatrix[1][2] = new String[][]{ap, cl, rj};
        smatrix[1][3] = new String[][]{cl};
        smatrix[1][4] = new String[][]{rj};
        String[][] result_status = (String[][])smatrix[cur_privilege][cur_status];
        String preSelected = this.g_VenueRequest.getStatus();
        if (preSelected.equals("")) {
            preSelected = User.hasPrivilege("venueRequestApprove") ? VenueRequest.STATUS__AP : VenueRequest.STATUS__WA;
        }
        ComboBoxCN c = new ComboBoxCN(ComboBoxCN.buildItemsByArray(result_status), preSelected);
        c.hasNilItem(false);
        return c;
    }

    private boolean isSaveEnabled() {
        if (!User.hasPrivilege("venueRequestModify")) {
            return false;
        }
        int cur_privilege = User.hasPrivilege("venueRequestApprove") ? 1 : 0;
        int cur_status = 0;
        if (this.g_VenueRequest.getStatus().isEmpty()) {
            cur_status = 0;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__WA)) {
            cur_status = 1;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__AP)) {
            cur_status = 2;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__CL)) {
            cur_status = 3;
        }
        if (this.g_VenueRequest.getStatus().equals(VenueRequest.STATUS__RJ)) {
            cur_status = 4;
        }
        boolean[][] smatrix = new boolean[2][5];
        smatrix[0][0] = true;
        smatrix[0][1] = true;
        smatrix[0][2] = false;
        smatrix[0][3] = false;
        smatrix[0][4] = false;
        smatrix[1][0] = true;
        smatrix[1][1] = true;
        smatrix[1][2] = true;
        smatrix[1][3] = false;
        smatrix[1][4] = false;
        return smatrix[cur_privilege][cur_status];
    }

    private void refreshEquipmentsMaxAvailQty() {
        RecordList eqs = this.itemSL.getTableData();
        int i = 0;
        while (i < eqs.size()) {
            eqs.setCurrentRow(i);
            double max_qty = VenueRequest.getMaxEqAvailQtyOfDays(this.g_VenueRequest.getVenue_request_seq(), eqs.getI(VenueRequestEquipment.VENUE_EQUIPMENT_SEQ), this.dateDP.getSelectedDates(), this.start_timeTT.getCommittedInput(), this.end_timeTT.getCommittedInput());
            eqs.setD("max_qty", max_qty);
            ++i;
        }
        this.itemSL.fireDataChanged();
    }

    private void setEventHandler() {
        this.venueNV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onChangeVenueCN(evt);
            }
        });
        this.dateDP.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.refreshEquipmentsMaxAvailQty();
            }
        });
        this.start_timeTT.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent evt) {
                VenueRequestInfoDialog.this.refreshEquipmentsMaxAvailQty();
            }

            @Override
            public void focusGained(FocusEvent evt) {
            }
        });
        this.end_timeTT.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent evt) {
                VenueRequestInfoDialog.this.refreshEquipmentsMaxAvailQty();
            }

            @Override
            public void focusGained(FocusEvent evt) {
            }
        });
        this.add_itemB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onAddItem(evt);
            }
        });
        this.del_itemB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onDelItem(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VenueRequestInfoDialog.this.onCancel(evt);
            }
        });
    }

    private void onChangeVenueCN(ActionEvent evt) {
        int venue_seq = this.venueNV.getSelectedIntValue();
        String user = String.valueOf(new Venue(venue_seq).getUser_capacity());
        this.max_userTF.setText(user);
        this.add_equipment_idNV.refreshItems(VenueRequest.getVenueEquipments(venue_seq));
        this.add_equipment_idNV.setItemSelected(-1);
        RecordList items = this.itemSL.getTableData();
        int i = items.size() - 1;
        while (i >= 0) {
            if (items.getI("venue_seq", i) != Venue.FREE_EQUIPMENT_SEQ) {
                items.remove(i);
            }
            --i;
        }
        this.itemSL.fireDataChanged();
    }

    private void onAddItem(ActionEvent evt) {
        int index = this.add_equipment_idNV.getSelectedIndex();
        int sel_vne_seq = this.add_equipment_idNV.getSelectedIntValue();
        RecordList r = this.itemSL.getTableData();
        Validation validation = new Validation();
        validation.add(this.venueNV.getSelectedIndex(), "\u5834\u5730", "CBNVIR");
        validation.add(index != 0, "\u8acb\u9078\u64c7\u8a2d\u5099", "RT");
        validation.add(r.indexOf(VenueEquipment.VENUE_EQUIPMENT_SEQ, sel_vne_seq) == -1, "\u6240\u9078\u7684\u8a2d\u5099\u5df2\u7d93\u52a0\u5165", "RT");
        validation.add(this.dateDP.getSelectedDates().size() > 0, "\u8acb\u8f38\u5165\u4f7f\u7528\u65e5\u671f", "R,RT");
        validation.add(this.start_timeTT.getInput(), "\u4f7f\u7528\u6642\u9593(\u958b\u59cb)", "R,T");
        validation.add(this.end_timeTT.getInput(), "\u4f7f\u7528\u6642\u9593(\u7d50\u675f)", "R,T");
        if (!validation.isValid()) {
            return;
        }
        RecordList eq = VenueEquipment.getEquipment(sel_vne_seq);
        eq.setCurrentRow(0);
        double max_qty = VenueRequest.getMaxEqAvailQtyOfDays(this.g_VenueRequest.getVenue_request_seq(), sel_vne_seq, this.dateDP.getSelectedDates(), this.start_timeTT.getInput(), this.end_timeTT.getInput());
        ComparableHashMap h = new ComparableHashMap();
        h.put(VenueRequestEquipment.VENUE_REQUEST_EQUIPMENT_SEQ, new Integer(-1));
        h.put(VenueRequestEquipment.VENUE_EQUIPMENT_SEQ, sel_vne_seq);
        h.put(VenueEquipment.VENUE_SEQ, eq.getI(VenueEquipment.VENUE_SEQ));
        h.put(VenueEquipment.NAME, eq.getS(VenueEquipment.NAME));
        h.put("max_qty", new BigDecimal(max_qty));
        h.put(VenueRequestEquipment.QTY, new BigDecimal(0));
        h.put(VenueEquipment.UNIT, eq.getS(VenueEquipment.UNIT));
        r.add(h);
        this.itemSL.fireDataChanged();
    }

    private void onDelItem(ActionEvent evt) {
        int sel_row = this.itemSL.getSelectedRow();
        if (sel_row == -1) {
            return;
        }
        RecordList v = this.itemSL.getTableData();
        v.remove(sel_row);
        this.itemSL.fireDataChanged();
    }

    private boolean onSave(ActionEvent evt) {
        Validation validation = new Validation();
        validation.add(this.venueNV.getSelectedIndex(), "\u5834\u5730", "CBNVIR");
        validation.add(this.dateDP.getSelectedDates().size() > 0, "\u8acb\u8f38\u5165\u4f7f\u7528\u65e5\u671f", "R,RT");
        validation.add(this.start_timeTT.getInput(), "\u4f7f\u7528\u6642\u9593(\u958b\u59cb)", "R,T");
        validation.add(this.end_timeTT.getInput(), "\u4f7f\u7528\u6642\u9593(\u7d50\u675f)", "R,T");
        validation.add(this.member_groupNV.getSelectedIntValue(), "\u4f7f\u7528\u7fa4\u7d44", "CBNVIR");
        validation.add(this.purposeCN.getSelectedCode(), "\u7528\u9014", "R");
        validation.add(this.user_numTF.getText(), "\u4f7f\u7528\u4eba\u6578", "R,I,GTZ");
        validation.add(this.memberNV.getSelectedIntValue(), "\u7533\u8acb\u4eba", "CBNVIR");
        validation.add(this.entry_dateDT.getInput(), "\u7533\u8acb\u65e5\u671f", "R,D");
        int over_user = Integer.parseInt(this.user_numTF.getText()) - Integer.parseInt(this.max_userTF.getText());
        validation.add(over_user <= 0, "\u4f7f\u7528\u4eba\u6578\u4e0d\u53ef\u5927\u904e\u53ef\u5bb9\u7d0d\u4eba\u6578", "RT");
        RecordList items = this.itemSL.getTableData();
        int i = 0;
        while (i < items.size()) {
            items.setCurrentRow(i);
            double qty = items.getD(VenueRequestEquipment.QTY);
            validation.add(qty, "\u7b2c" + (i + 1) + "\u9805\u7684\u8a2d\u5099\u6578\u91cf", "R,F,GTZ");
            double max_qty = items.getD("max_qty");
            validation.add(max_qty - qty >= 0.0, "\u7b2c" + (i + 1) + "\u9805\u7684\u8a2d\u5099\u6578\u91cf\u5927\u904e\u7e3d\u53ef\u7528\u91cf", "RT");
            ++i;
        }
        if (!validation.isValid()) {
            return false;
        }
        String venueStartTime = TimeUtil.getStringByTime(Config.getT(Config.venueStartTime));
        String venueEndTime = TimeUtil.getStringByTime(Config.getT(Config.venueEndTime));
        String msg = "\u5834\u5730\u5df2\u88ab\u4e0b\u9762\u7684\u7533\u8acb\u6240\u4f7f\u7528:\n";
        boolean isOverlapped = false;
        Venue venue = new Venue(this.venueNV.getSelectedIntValue());
        if (venue.getOverlap().equals(SystemCode.YN__N)) {
            int i2 = 0;
            while (i2 < this.dateDP.getSelectedDates().size()) {
                String date = (String)this.dateDP.getSelectedDates().get(i2);
                RecordList overlaps = VenueRequest.getOverlappedRequests(this.g_VenueRequest.getVenue_request_seq(), this.venueNV.getSelectedIntValue(), this.start_timeTT.getTime(date), this.end_timeTT.getTime(date));
                if (!overlaps.isEmpty()) {
                    isOverlapped = true;
                    int j = 0;
                    while (j < overlaps.size()) {
                        overlaps.setCurrentRow(j);
                        msg = String.valueOf(msg) + TimeUtil.getStringByDate(overlaps.getT("start_time")) + " " + TimeUtil.getStringByTime(overlaps.getT("start_time")) + "-" + TimeUtil.getStringByTime(overlaps.getT("end_time")) + " " + overlaps.getS("purpose") + " " + overlaps.getI("user_num") + Lang.set("\u4eba") + " " + overlaps.getS("display_name") + "\n";
                        ++j;
                    }
                }
                ++i2;
            }
        }
        if (isOverlapped) {
            WinUtil.showMessage(this, msg);
            return false;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        int i3 = 0;
        while (i3 < this.dateDP.getSelectedDates().size()) {
            String date = (String)this.dateDP.getSelectedDates().get(i3);
            if (this.g_IsUpdate) {
                VenueRequest.update(this.g_VenueRequest.getVenue_request_seq(), this.venueNV.getSelectedIntValue(), this.statusCN.getSelectedCode(), this.memberNV.getSelectedIntValue(), this.entry_dateDT.getDate(), this.start_timeTT.getTime(date), this.end_timeTT.getTime(date), this.member_groupNV.getSelectedIntValue(), this.purposeCN.getSelectedCode(), this.remarkTF.getText(), Integer.parseInt(this.user_numTF.getText()), items);
            } else {
                VenueRequest.insert(this.venueNV.getSelectedIntValue(), this.statusCN.getSelectedCode(), this.memberNV.getSelectedIntValue(), this.entry_dateDT.getDate(), this.start_timeTT.getTime(date), this.end_timeTT.getTime(date), this.member_groupNV.getSelectedIntValue(), this.purposeCN.getSelectedCode(), this.remarkTF.getText(), Integer.parseInt(this.user_numTF.getText()), items);
            }
            ++i3;
        }
        if (this.g_IsAddFromActivity) {
            ((ActivityListDialog)this.getParent()).onSearch(null);
        } else {
            ((VenueRequestListDialog)this.getParent()).onSearch(null);
        }
        wait_dialog.dispose();
        this.dispose();
        return true;
    }

    private void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

