/*
 * Decompiled with CFR 0.152.
 */
package venue;

import database.DBConn;
import database.DBUtil;
import util.RecordList;
import util.RecordListSet;

public class VenueEquipment {
    private int g_Venue_seq = -1;
    private RecordList g_Items = null;
    public static String VENUE_EQUIPMENT_SEQ = "venue_equipment_seq";
    public static String VENUE_SEQ = "venue_seq";
    public static String NAME = "name";
    public static String DESC = "desc";
    public static String QTY = "qty";
    public static String UNIT = "unit";
    public static String STATUS = "status";

    public VenueEquipment(int venue_seq) {
        this.g_Venue_seq = venue_seq;
        DBConn conn = new DBConn();
        this.g_Items = VenueEquipment.load(this.g_Venue_seq, conn);
        conn.commit();
    }

    public RecordList getItems() {
        return this.g_Items;
    }

    public static RecordList load(int venue_seq, DBConn conn) {
        String sql = "select * from venue_equipment where venue_seq=? order by name";
        return DBUtil.run(sql, venue_seq, conn);
    }

    public static void update(int venue_seq, RecordList items, DBConn conn) {
        RecordList old_items = VenueEquipment.load(venue_seq, conn);
        RecordListSet set = new RecordListSet(old_items, items, new String[]{VENUE_EQUIPMENT_SEQ});
        RecordList r = set.getLeftOnly();
        int i = 0;
        while (i < r.size()) {
            int seq = r.getI(VENUE_EQUIPMENT_SEQ, i);
            VenueEquipment.delete(seq, conn);
            ++i;
        }
        r = set.getIntersectOfRight();
        i = 0;
        while (i < r.size()) {
            VenueEquipment.update(r, i, conn);
            ++i;
        }
        r = set.getRightOnly();
        i = 0;
        while (i < r.size()) {
            VenueEquipment.insert(r, venue_seq, i, conn);
            ++i;
        }
    }

    private static void insert(RecordList items, int venue_seq, int i, DBConn conn) {
        String sql = "insert into venue_equipment( venue_equipment_seq,venue_seq,name,desc,qty,unit,status)values(?,?,?,?,?,?,?)";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{DBUtil.getNextValueFor("venue_equipment_seq", conn), new Integer(venue_seq), items.getS(NAME), items.getS(DESC), items.getBigDecimal(QTY), items.getS(UNIT), items.getS(STATUS)};
        DBUtil.run(sql, pvs, conn);
    }

    private static void update(RecordList items, int i, DBConn conn) {
        String sql = "update venue_equipment set name=?,desc=?,qty=?,unit=?,status=? where venue_equipment_seq=?";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{items.getS(NAME), items.getS(DESC), items.getBigDecimal(QTY), items.getS(UNIT), items.getS(STATUS), items.getInteger(VENUE_EQUIPMENT_SEQ)};
        DBUtil.run(sql, pvs, conn);
    }

    private static void delete(int seq, DBConn conn) {
        String sql = "delete from venue_equipment where venue_equipment_seq=?";
        DBUtil.run(sql, seq, conn);
    }

    public static RecordList getEquipment(int venue_equipment_seq) {
        String sql = "select * from venue_equipment where venue_equipment_seq=?";
        return DBUtil.run(sql, venue_equipment_seq);
    }
}

