/*
 * Decompiled with CFR 0.152.
 */
package system;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import member.Member;
import system.User;
import system.UserInfoDialog;
import ui.ListDialog;
import ui.ScrollList;
import ui.TableLayout;
import util.ArrayUtil;
import util.RecordList;

public class UserListDialog
extends ListDialog {
    private JButton addB;
    private JButton modifyB;
    private JButton copyB;
    private ScrollList listSL;
    private RecordList g_List = User.search();

    public UserListDialog(JFrame frame) {
        super(frame, "\u4f7f\u7528\u8005\u5217\u8868", false);
        this.setLayout();
        this.setEventHandler();
        this.showDialog();
    }

    public void setLayout() {
        this.addB = new JButton("\u65b0\u589e");
        this.modifyB = new JButton("\u4fee\u6539/\u6aa2\u8996");
        this.copyB = new JButton("\u8907\u88fd");
        this.addB.setEnabled(User.hasPrivilege("userModify"));
        this.copyB.setEnabled(User.hasPrivilege("userModify"));
        this.listSL = new ScrollList(560, 410, this.g_List, new int[]{355, 80, 150}, new String[]{"\u59d3\u540d", "\u73fe\u6cc1", "\u6700\u5f8c\u767b\u5165\u6642\u9593"}, new String[]{Member.DISPLAY_NAME, "status", "last_login_time"}, new boolean[3]);
        this.listSL.setDateTimeTextFieldColumn("last_login_time");
        this.listSL.setSortCol(Member.DISPLAY_NAME, true);
        this.addResizeComp(this.listSL, true, true);
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        t.addTable(new int[]{565}, new int[]{30, 30, 30});
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 0, 0, 1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.modifyB, 0, 1, 1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.copyB, 0, 2, 1, 0, 115, -1);
        t.addYSpace(15);
        int[] nArray = new int[1];
        t.getClass();
        nArray[0] = 0;
        t.addTable(nArray, new int[]{410});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    public void setEventHandler() {
        this.addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserListDialog.this.onAdd(evt);
            }
        });
        this.modifyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserListDialog.this.onModify(evt);
            }
        });
        this.copyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserListDialog.this.onCopy(evt);
            }
        });
        this.listSL.getViewport().getView().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    UserListDialog.this.onModify(null);
                }
            }
        });
        this.listSL.getViewport().getView().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    UserListDialog.this.onModify(null);
                }
            }
        });
    }

    public void onSearch(ActionEvent evt) {
        this.g_List = User.search();
        this.listSL.refreshTable(this.g_List);
    }

    public void onAdd(ActionEvent evt) {
        UserInfoDialog d = new UserInfoDialog((ListDialog)this, -1, false);
    }

    public void onModify(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int user_seq = ArrayUtil.getInt("user_seq", selrow, this.listSL.getTableData());
            UserInfoDialog userInfoDialog = new UserInfoDialog((ListDialog)this, user_seq, true);
        }
    }

    public void onCopy(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int user_seq = ArrayUtil.getInt("user_seq", selrow, this.listSL.getTableData());
            UserInfoDialog userInfoDialog = new UserInfoDialog((ListDialog)this, user_seq, false);
        }
    }
}

