/*
 * Decompiled with CFR 0.152.
 */
package printout.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import system.Config;
import system.Constants;
import system.SystemCode;
import util.Tools;

public class PDFPrintout {
    public static final float MM2PT = 2.8346f;
    public static final int INCH2PT = 72;
    public static final int SYS_IMG_RESOLUTION = 72;
    public static String A4 = "A4";
    public static String A4L = "A4L";
    public static String A4H = "A4H";
    private Document g_Document = null;
    private BaseFont g_Font = null;

    public PDFPrintout(String page_size, int margin_left, int margin_right, int margin_top, int margin_bottom, String output_path) {
        Rectangle r = null;
        r = page_size.equals(A4) ? PageSize.A4 : (page_size.equals(A4L) ? PageSize.A4.rotate() : (page_size.equals(A4H) ? PageSize.A5.rotate() : PageSize.A4));
        this.g_Document = new Document(r, (float)margin_left * 2.8346f, (float)margin_right * 2.8346f, (float)margin_top * 2.8346f, (float)margin_bottom * 2.8346f);
        try {
            PdfWriter.getInstance((Document)this.g_Document, (OutputStream)new FileOutputStream(output_path));
            this.g_Font = BaseFont.createFont((String)"MHei-Medium", (String)"UniCNS-UCS2-H", (boolean)false);
        }
        catch (DocumentException e) {
            Tools.writeError(e.getMessage());
        }
        catch (IOException e) {
            Tools.writeError(e.getMessage());
        }
        this.g_Document.open();
        try {
            this.g_Document.add((Element)new Paragraph("We use a locked width:\n\n"));
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    public void genFile() {
        this.g_Document.close();
    }

    public void addTable(PdfPTable table) {
        try {
            this.g_Document.add((Element)table);
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    public static String getFullFontPath() {
        if (!Constants.FONT_PATH.equals("")) {
            String idx = Constants.FONT_INDEX;
            if (idx.equals("")) {
                return Constants.FONT_PATH;
            }
            return String.valueOf(Constants.FONT_PATH) + "," + idx;
        }
        if (Config.getS(Config.lang).equals(SystemCode.LANG__TC)) {
            return "webtool/font/bsmi00lp.ttf";
        }
        return "webtool/font/gbsn00lp.ttf";
    }
}

