/*
 * Decompiled with CFR 0.152.
 */
package member;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import member.Member;
import member.MemberAttendanceListDialog;
import member.MemberCardPrintout;
import member.MemberGroup;
import member.MemberGroupListDialog;
import member.MemberInfoDialog;
import member.MemberLabelPrintoutDialog;
import member.MemberReceiptListDialog;
import system.MasterCode;
import system.User;
import system.UserPrivilege;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.ListDialog;
import ui.ScrollList;
import ui.TableLayout;
import util.ArrayUtil;
import util.RecordList;
import util.WinUtil;

public class MemberListDialog
extends ListDialog {
    private JButton searchB;
    private JButton addB;
    private JButton modifyB;
    private JButton attendanceB;
    private JButton receiptB;
    private JButton groupB;
    private JButton print_cardB;
    private JButton print_labelB;
    private JTextField member_idTF;
    private JTextField nameTF;
    private JTextField member_remarkTF;
    private ComboBoxNV member_groupNV;
    private ComboBoxCN member_remarkCN;
    private JCheckBox selectAllCB;
    private JCheckBox searchListCB;
    private JCheckBox showInclInActiveCB;
    private ScrollList listSL;
    private ArrayList g_List;
    private RecordList g_UserMgs = User.getMGsByPrivilege("memberRead", true);

    public MemberListDialog(JFrame frame) {
        super(frame, "\u6703\u773e\u5217\u8868", false);
        this.g_List = Member.search("", "", false, this.g_UserMgs.getI(UserPrivilege.MEMBER_GROUP_SEQ, 0), "", "");
        this.setLayout();
        this.setEventHandler();
        this.showDialog();
    }

    public void setLayout() {
        this.member_idTF = new JTextField();
        this.nameTF = new JTextField();
        this.member_remarkTF = new JTextField();
        this.searchB = new JButton("\u641c\u5c0b");
        this.addB = new JButton("\u65b0\u589e");
        this.modifyB = new JButton("\u4fee\u6539/\u6aa2\u8996");
        this.attendanceB = new JButton("\u51fa\u5e2d\u8a18\u9304");
        this.receiptB = new JButton("\u6536\u64da\u8a18\u9304");
        this.groupB = new JButton("\u7fa4\u7d44\u8a18\u9304");
        this.print_cardB = new JButton("\u5217\u5370\u6703\u773e\u8b49");
        this.print_labelB = new JButton("\u5217\u5370\u6703\u773e\u6a19\u7c64");
        this.selectAllCB = new JCheckBox("\u5217\u8868\u5168\u9078", false);
        this.searchListCB = new JCheckBox("\u5217\u8868\u4e2d\u641c\u5c0b", false);
        this.showInclInActiveCB = new JCheckBox("\u986f\u793a\u5df2\u5931\u6548", false);
        this.setDefaultButton(this.searchB);
        RecordList mg = MemberGroup.getGroupNames(this.g_UserMgs, "name", "member_group_seq");
        this.member_groupNV = new ComboBoxNV((ArrayList)mg, "name", "member_group_seq", -1, false);
        this.member_remarkCN = new ComboBoxCN(MasterCode.getCodes("MEMBER_REMARK"));
        this.addB.setEnabled(User.hasPrivilegeInGroup("memberModify", MemberGroup.ROOT_GROUP_SEQ));
        this.receiptB.setEnabled(User.hasPrivilege("receiptRead"));
        TableLayout t = new TableLayout(this, 730, 570, 5, 10);
        int[] nArray = new int[4];
        nArray[0] = 80;
        nArray[1] = 380;
        nArray[2] = 130;
        t.getClass();
        nArray[3] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30});
        JLabel jLabel = new JLabel("\u59d3\u540d");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.nameTF, 1, 0, 20, 0, 200, -1);
        t.getClass();
        t.addCell(this.searchListCB, 1, 0, 240, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.searchB, 2, 0, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.addB, 3, 0, -1, 0, 115, -1);
        JLabel jLabel2 = new JLabel("\u6703\u773e\u7de8\u865f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.member_idTF, 1, 1, 20, 0, 200, -1);
        t.getClass();
        t.addCell(this.selectAllCB, 1, 1, 240, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.groupB, 2, 1, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.modifyB, 3, 1, -1, 0, 115, -1);
        JLabel jLabel3 = new JLabel("\u6703\u773e\u7fa4\u7d44");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 2, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.member_groupNV, 1, 2, 20, 0, 200, -1);
        t.getClass();
        t.addCell(this.showInclInActiveCB, 1, 2, 240, 0);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.attendanceB, 2, 2, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.print_cardB, 3, 2, -1, 0, 115, -1);
        JLabel jLabel4 = new JLabel("\u5099\u8a3b");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, 3, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.member_remarkCN, 1, 3, 20, 0, 100, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.member_remarkTF, 1, 3, 120, 0, 100, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.receiptB, 2, 3, -1, 0, 115, -1);
        t.getClass();
        t.getClass();
        t.getClass();
        t.addCell(this.print_labelB, 3, 3, -1, 0, 115, -1);
        boolean[] blArray = new boolean[5];
        blArray[4] = true;
        this.listSL = new ScrollList(690, 375, this.g_List, new int[]{100, 220, 150, 180, 40}, new String[]{"\u6703\u773e\u7de8\u865f", "\u59d3\u540d", "\u96fb\u8a71", "\u96fb\u90f5", "\u9078\u53d6"}, new String[]{"member_id", Member.DISPLAY_NAME, "tel", "email", "selected"}, blArray);
        this.listSL.setCheckBoxYNColumn("selected", "Y", "N");
        this.addResizeComp(this.listSL, true, true);
        t.addYSpace(15);
        int[] nArray2 = new int[1];
        t.getClass();
        nArray2[0] = 0;
        t.addTable(nArray2, new int[]{380});
        t.getClass();
        t.getClass();
        t.addCell(this.listSL, 0, 0, -1, -1);
    }

    public void setEventHandler() {
        this.searchB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onSearch(evt);
            }
        });
        this.addB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onAdd(evt);
            }
        });
        this.modifyB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onModify(evt);
            }
        });
        this.listSL.getViewport().getView().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MemberListDialog.this.onModify(null);
                }
            }
        });
        this.listSL.getViewport().getView().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    MemberListDialog.this.onModify(null);
                }
                if (evt.getKeyCode() == 32) {
                    MemberListDialog.this.onSelect(null);
                }
            }
        });
        this.attendanceB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onViewAttendance(evt);
            }
        });
        this.receiptB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onViewReceipt(evt);
            }
        });
        this.groupB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onViewGroup(evt);
            }
        });
        this.print_cardB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onPrintCard(evt);
            }
        });
        this.print_labelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onPrintLabel(evt);
            }
        });
        this.selectAllCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onSelectAll(evt);
            }
        });
        this.searchListCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MemberListDialog.this.onSearchList(evt);
            }
        });
    }

    public void onSearch(ActionEvent evt) {
        if (this.searchListCB.isSelected()) {
            this.listSL.searchList(this.nameTF.getText());
        } else {
            ArrayList v = Member.search(this.member_idTF.getText(), this.nameTF.getText(), this.showInclInActiveCB.isSelected(), this.member_groupNV.getSelectedIntValue(), this.member_remarkCN.getSelectedCode(), this.member_remarkTF.getText());
            this.listSL.refreshTable(v);
            this.selectAllCB.setSelected(false);
        }
    }

    public void onSelect(ActionEvent evt) {
        ArrayList v;
        int selrow = this.listSL.getSelectedRow();
        String selected = ArrayUtil.getString("SELECTED", selrow, v = this.listSL.getTableData());
        ArrayUtil.setString("SELECTED", selected.equals("Y") ? "N" : "Y", selrow, v);
        this.listSL.refreshTableRow(selrow);
    }

    public void onAdd(ActionEvent evt) {
        MemberInfoDialog d = new MemberInfoDialog(this);
    }

    public void onModify(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int member_seq = ArrayUtil.getInt("MEMBER_SEQ", selrow, this.listSL.getTableData());
            MemberInfoDialog memberInfoDialog = new MemberInfoDialog(this, member_seq);
        }
    }

    public void onViewAttendance(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int member_seq = ArrayUtil.getInt("MEMBER_SEQ", selrow, this.listSL.getTableData());
            MemberAttendanceListDialog memberAttendanceListDialog = new MemberAttendanceListDialog(this, member_seq);
        }
    }

    public void onViewReceipt(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int member_seq = ArrayUtil.getInt("MEMBER_SEQ", selrow, this.listSL.getTableData());
            MemberReceiptListDialog memberReceiptListDialog = new MemberReceiptListDialog(this, member_seq);
        }
    }

    public void onViewGroup(ActionEvent evt) {
        int selrow = this.listSL.getSelectedRow();
        if (selrow != -1) {
            int member_seq = ArrayUtil.getInt("MEMBER_SEQ", selrow, this.listSL.getTableData());
            MemberGroupListDialog memberGroupListDialog = new MemberGroupListDialog(this, member_seq);
        }
    }

    public void onPrintCard(ActionEvent evt) {
        ArrayList<Integer> member_seqs = new ArrayList<Integer>();
        int i = 0;
        while (i < this.listSL.getTableData().size()) {
            if (ArrayUtil.getString("SELECTED", i, this.listSL.getTableData()).equals("Y")) {
                int member_seq = ArrayUtil.getInt("MEMBER_SEQ", i, this.listSL.getTableData());
                member_seqs.add(new Integer(member_seq));
            }
            ++i;
        }
        if (!member_seqs.isEmpty()) {
            DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
            MemberCardPrintout p = new MemberCardPrintout(member_seqs);
            p.genFile();
            wait_dialog.dispose();
        } else {
            WinUtil.showMessage(this, "\u8acb\u5728\u9078\u53d6\u683c\u5167\u9078\u53d6\u6703\u773e");
        }
    }

    public void onPrintLabel(ActionEvent evt) {
        ArrayList<Integer> member_seqs = new ArrayList<Integer>();
        int i = 0;
        while (i < this.listSL.getTableData().size()) {
            if (ArrayUtil.getString("SELECTED", i, this.listSL.getTableData()).equals("Y")) {
                int member_seq = ArrayUtil.getInt("MEMBER_SEQ", i, this.listSL.getTableData());
                member_seqs.add(new Integer(member_seq));
            }
            ++i;
        }
        if (!member_seqs.isEmpty()) {
            MemberLabelPrintoutDialog d = new MemberLabelPrintoutDialog(this, member_seqs);
        } else {
            WinUtil.showMessage(this, "\u8acb\u5728\u9078\u53d6\u683c\u5167\u9078\u53d6\u6703\u773e");
        }
    }

    public void onSelectAll(ActionEvent evt) {
        ArrayList v = this.listSL.getTableData();
        int i = 0;
        while (i < v.size()) {
            ArrayUtil.setString("SELECTED", this.selectAllCB.isSelected() ? "Y" : "N", i, v);
            ++i;
        }
        this.listSL.refreshTable(v);
    }

    public void onSearchList(ActionEvent evt) {
        this.member_groupNV.setEnabled(!this.searchListCB.isSelected());
        this.member_idTF.setEnabled(!this.searchListCB.isSelected());
    }
}

