/*
 * Decompiled with CFR 0.152.
 */
package member;

import database.DBConn;
import database.DBUtil;
import database.SQLWhereClause;
import member.MemberGroup;
import util.RecordList;
import util.RecordListSet;

public class MemberGroupPrivilege {
    private int g_Member_group_seq = -1;
    private RecordList g_Items = null;
    public static String MEMBER_GROUP_PRIVILEGE_SEQ = "member_group_privilege_seq";
    public static String MEMBER_GROUP_SEQ = "member_group_seq";
    public static String TYPE = "type";
    public static String NAME = "name";
    public static String CODE = "code";
    public static String STATUS = "status";
    public static String TYPE__SYSTEM = "S";
    public static String TYPE__DEFINE = "D";
    public static String TYPE__PARENT = "P";

    public MemberGroupPrivilege(int member_group_seq) {
        this.g_Member_group_seq = member_group_seq;
        DBConn conn = new DBConn();
        this.g_Items = MemberGroupPrivilege.load(this.g_Member_group_seq, conn);
        conn.commit();
    }

    public RecordList getItems() {
        return this.g_Items;
    }

    private static RecordList load(int member_group_seq, DBConn conn) {
        String sql = "select * from member_group_privilege where member_group_seq=? order by type desc,status,name";
        return DBUtil.run("select * from member_group_privilege where member_group_seq=? order by type desc,status,name", new Integer(member_group_seq));
    }

    public static void update(int member_group_seq, int parent_group_seq, RecordList items) {
        DBConn conn = new DBConn();
        MemberGroupPrivilege.delete(member_group_seq, conn);
        int i = 0;
        while (i < items.size()) {
            MemberGroupPrivilege.insert(items, i, conn);
            ++i;
        }
        MemberGroupPrivilege.updateGroupPrivilege(member_group_seq, parent_group_seq, conn);
        conn.commit();
    }

    public static void updateGroupPrivilege(int member_group_seq, int parent_group_seq, DBConn conn) {
        MemberGroupPrivilege.deleteParentTypePrivileges(member_group_seq, conn);
        RecordList parentGroupPrivileges = MemberGroupPrivilege.getGroupPrivileges(parent_group_seq, "", conn);
        RecordList definePrivileges = MemberGroupPrivilege.getGroupPrivileges(member_group_seq, TYPE__DEFINE, conn);
        RecordListSet set = new RecordListSet(parentGroupPrivileges, definePrivileges, new String[]{CODE});
        RecordList parentTypePrivileges = set.getLeftOnly();
        int i = 0;
        while (i < parentTypePrivileges.size()) {
            parentTypePrivileges.setI(MEMBER_GROUP_SEQ, member_group_seq, i);
            parentTypePrivileges.setS(TYPE, TYPE__PARENT, i);
            MemberGroupPrivilege.insert(parentTypePrivileges, i, conn);
            ++i;
        }
        RecordList childGroups = MemberGroup.getChildGroups(member_group_seq, conn);
        int i2 = 0;
        while (i2 < childGroups.size()) {
            int mg_seq = childGroups.getI(MEMBER_GROUP_SEQ, i2);
            int pg_seq = childGroups.getI("parent_group_seq", i2);
            MemberGroupPrivilege.updateGroupPrivilege(mg_seq, pg_seq, conn);
            ++i2;
        }
    }

    private static void insert(RecordList items, int i, DBConn conn) {
        String sql = "insert into member_group_privilege( member_group_privilege_seq,member_group_seq,type,name,code,status)values(?,?,?,?,?,?)";
        items.setCurrentRow(i);
        Object[] pvs = new Object[]{DBUtil.getNextValueFor(MEMBER_GROUP_PRIVILEGE_SEQ, conn), items.getInteger(MEMBER_GROUP_SEQ), items.getS(TYPE), items.getS(NAME), items.getS(CODE), items.getS(STATUS)};
        DBUtil.run("insert into member_group_privilege( member_group_privilege_seq,member_group_seq,type,name,code,status)values(?,?,?,?,?,?)", pvs, conn);
    }

    private static void delete(int member_group_seq, DBConn conn) {
        String sql = "delete from member_group_privilege where member_group_seq=?";
        Object[] pvs = new Object[]{new Integer(member_group_seq)};
        DBUtil.run("delete from member_group_privilege where member_group_seq=?", pvs, conn);
    }

    private static void deleteParentTypePrivileges(int member_group_seq, DBConn conn) {
        String sql = "delete from member_group_privilege where member_group_seq=? and type=?";
        Object[] pvs = new Object[]{new Integer(member_group_seq), TYPE__PARENT};
        DBUtil.run("delete from member_group_privilege where member_group_seq=? and type=?", pvs, conn);
    }

    private static RecordList getGroupPrivileges(int member_group_seq, String type, DBConn conn) {
        SQLWhereClause clause = new SQLWhereClause("and", new String[]{"type LIKE ?"}, new Object[]{type});
        String sql = "select * from member_group_privilege where member_group_seq=" + member_group_seq + clause.getConds();
        return DBUtil.run(sql, clause.getPrepValues(), conn);
    }

    public static void markSystemPrivilege(RecordList items) {
        int i = 0;
        while (i < items.size()) {
            items.setCurrentRow(i);
            if (items.getI(MEMBER_GROUP_PRIVILEGE_SEQ) < -1) {
                items.setS("sys", "Y");
            } else {
                items.setS("sys", "N");
            }
            ++i;
        }
    }
}

