/*
 * Decompiled with CFR 0.152.
 */
package database;

import database.DBUtil;
import java.sql.Connection;
import util.Tools;

public class DBConn {
    private boolean gIsRunnable;
    private boolean gIsSuccessful = false;
    private boolean gIsSingleQuery;
    private Connection gConn;

    public boolean isRunnable() {
        return this.gIsRunnable;
    }

    public boolean isSuccessful() {
        return this.gIsSuccessful;
    }

    public Connection getConn() {
        return this.gConn;
    }

    public DBConn() {
        this(false);
    }

    public DBConn(boolean is_single_query) {
        this.gIsSingleQuery = is_single_query;
        try {
            this.gConn = DBUtil.getConnPool().getConnection(2000L);
            if (!this.gIsSingleQuery) {
                this.gConn.setAutoCommit(false);
            }
            this.gIsRunnable = true;
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
    }

    public void commit() {
        try {
            if (this.gIsRunnable) {
                this.gConn.commit();
                this.gIsSuccessful = true;
            }
            if (!this.gIsSingleQuery) {
                this.gConn.setAutoCommit(true);
            }
            this.gConn.close();
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
    }

    public void rollback() {
        try {
            this.gConn.rollback();
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
        this.gIsRunnable = false;
    }
}

