/*
 * Decompiled with CFR 0.152.
 */
package account;

import account.Account;
import account.AccountListDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import system.SystemCode;
import system.User;
import ui.ComboBoxCN;
import ui.ComboBoxNV;
import ui.DataDialog;
import ui.TableLayout;
import util.Validation;
import util.WinUtil;

public class AccountInfoDialog
extends DataDialog {
    ComboBoxNV parent_acNV;
    ComboBoxCN typeCN;
    private ComboBoxCN statusCN;
    JTextField idTF;
    JTextField nameTF;
    JTextField remarkTF;
    JCheckBox is_parentCB;
    JButton saveB;
    JButton cancelB;
    private Account g_Account = null;
    private boolean g_isUpdate = false;

    public AccountInfoDialog(DataDialog f, int ac_seq, boolean isUpdate) {
        super(f, "\u65b0\u589e\u6703\u8a08\u5e33\u6236", false);
        if (isUpdate) {
            this.setTitle("\u4fee\u6539\u6703\u8a08\u5e33\u6236");
        }
        this.g_isUpdate = isUpdate;
        this.init(ac_seq);
    }

    private void init(int ac_seq) {
        this.g_Account = new Account(ac_seq);
        this.setEditLayout();
        this.setEventHandler();
        this.onSelectParentAccount(null);
        this.lockForExistChildAccount();
        this.setVisible(true);
    }

    void setEditLayout() {
        this.parent_acNV = new ComboBoxNV(Account.getAllParentAccounts(), "name", "ac_seq", this.g_Account.getParent_ac_seq());
        this.typeCN = new ComboBoxCN(SystemCode.getAccount(), this.g_Account.getType());
        this.typeCN.getSelectedCode();
        this.statusCN = new ComboBoxCN(SystemCode.getStatus(), this.g_Account.getStatus());
        this.statusCN.hasNilItem(false);
        if (!this.g_isUpdate) {
            this.statusCN.setSelectedCode(SystemCode.STATUS__A);
        }
        this.idTF = new JTextField(this.g_Account.getId());
        this.nameTF = new JTextField(this.g_Account.getName());
        this.remarkTF = new JTextField(this.g_Account.getRemark());
        this.is_parentCB = new JCheckBox("\u7528\u65bc\u5206\u5c64", this.g_Account.getIs_parent().equals("Y"));
        this.saveB = new JButton("\u78ba\u5b9a");
        this.cancelB = new JButton("\u53d6\u6d88");
        this.saveB.setEnabled(User.hasPrivilege("accountModify"));
        TableLayout t = new TableLayout(this, 380, 280, 5, 10);
        int[] nArray = new int[3];
        nArray[0] = 80;
        nArray[1] = 180;
        t.getClass();
        nArray[2] = 0;
        t.addTable(nArray, new int[]{30, 30, 30, 30, 30, 30});
        JLabel jLabel = new JLabel("\u4e0a\u5c64\u5e33\u6236");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.parent_acNV, 1, 0, 20, 0, 170, -1);
        t.getClass();
        t.addCell(this.is_parentCB, 2, 0, 20, 0);
        JLabel jLabel2 = new JLabel("\u5e33\u6236\u985e\u578b");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.typeCN, 1, 1, 20, 0, 170, -1);
        JLabel jLabel3 = new JLabel("\u5e33\u6236\u7de8\u865f");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 2, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.idTF, 1, 2, 20, 0, 170, -1);
        JLabel jLabel4 = new JLabel("\u5e33\u6236\u540d\u7a31");
        t.getClass();
        t.getClass();
        t.addCell(jLabel4, 0, 3, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.nameTF, 1, 3, 20, 0, 170, -1);
        JLabel jLabel5 = new JLabel("\u73fe\u6cc1");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, 4, 1, 0);
        t.getClass();
        t.addCell(this.statusCN, 1, 4, 20, 0);
        JLabel jLabel6 = new JLabel("\u5099\u8a3b");
        t.getClass();
        t.getClass();
        t.addCell(jLabel6, 0, 5, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.remarkTF, 1, 5, 20, 0, 250, -1);
        t.addYSpace(15);
        t.addTable(new int[]{280, 15, 80}, new int[]{30});
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 0, 0, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.cancelB, 2, 0, -1, 0);
    }

    void setEventHandler() {
        this.parent_acNV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountInfoDialog.this.onSelectParentAccount(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountInfoDialog.this.onSave(evt);
            }
        });
        this.cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AccountInfoDialog.this.onCancel(evt);
            }
        });
    }

    void onSelectParentAccount(ActionEvent evt) {
        if (this.parent_acNV.isSelected()) {
            int ac_seq = this.parent_acNV.getSelectedIntValue();
            Account c = new Account(ac_seq);
            this.typeCN.setSelectedCode(c.getType());
            this.typeCN.setEnabled(false);
        } else {
            this.typeCN.setEnabled(true);
        }
    }

    void lockForExistChildAccount() {
        if (Account.existChild(this.g_Account.getAc_seq())) {
            this.parent_acNV.setEnabled(false);
            this.typeCN.setEnabled(false);
            this.is_parentCB.setEnabled(false);
        }
    }

    void onSave(ActionEvent evt) {
        int seq;
        Validation validation = new Validation();
        validation.add(this.typeCN.getSelectedCode(), "\u5e33\u6236\u985e\u578b", "R");
        validation.add(this.idTF.getText(), "\u5e33\u6236\u7de8\u865f", "R");
        validation.add(this.nameTF.getText(), "\u5e33\u6236\u540d\u7a31", "R");
        if (!this.is_parentCB.isSelected()) {
            validation.add(this.parent_acNV.isSelected(), "\u82e5\u4e0d\u662f\u7e3d\u5e33\u985e\u8acb\u4e0a\u5c64\u5e33\u6236", "RT");
        }
        if (!((seq = Account.getAc_seq(this.idTF.getText())) == -1 || this.g_isUpdate && seq == this.g_Account.getAc_seq())) {
            validation.add(false, "\u5e33\u6236\u7de8\u865f " + this.idTF.getText() + "\u5df2\u5b58\u5728", "RT");
        }
        if (!validation.isValid()) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        if (this.g_isUpdate) {
            Account.update(this.g_Account.getAc_seq(), this.idTF.getText(), this.is_parentCB.isSelected() ? "Y" : "N", this.nameTF.getText(), this.parent_acNV.getSelectedIntValue(), this.typeCN.getSelectedCode(), this.statusCN.getSelectedCode(), this.remarkTF.getText());
        } else {
            Account.insert(this.idTF.getText(), this.is_parentCB.isSelected() ? "Y" : "N", this.nameTF.getText(), this.parent_acNV.getSelectedIntValue(), this.typeCN.getSelectedCode(), this.statusCN.getSelectedCode(), this.remarkTF.getText());
        }
        ((AccountListDialog)this.getParent()).onSearch(null);
        wait_dialog.dispose();
        this.dispose();
    }

    void onCancel(ActionEvent evt) {
        this.dispose();
    }
}

