/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.lib.KMPSearchAlgorithm;

public class JDBCBlobFile
implements Blob {
    public static final String TEMP_FILE_PREFIX = "hsql_jdbc_blob_file_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private static final int COPY_BUFFER_CAPACITY = 8192;
    private final File m_file;
    private boolean m_closed;
    private boolean m_temp;
    private List m_streams = new ArrayList();

    @Override
    public long length() throws SQLException {
        this.checkClosed();
        try {
            return this.m_file.length();
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
    }

    @Override
    public byte[] getBytes(long l, int n) throws SQLException {
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n2 = Math.min(8192, n);
        try {
            inputStream = this.getBinaryStream(l, n);
            byteArrayOutputStream = new ByteArrayOutputStream(n2);
            InOutUtil.copy(inputStream, byteArrayOutputStream, (long)n);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.getBinaryStream(1L, Long.MAX_VALUE);
    }

    @Override
    public long position(byte[] byArray, long l) throws SQLException {
        if (l < 1L) {
            throw Util.outOfRangeArgument("start: " + l);
        }
        if (byArray == null || byArray.length == 0 || l > this.length()) {
            return -1L;
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getBinaryStream(l, Long.MAX_VALUE);
            long l2 = KMPSearchAlgorithm.search(inputStream, byArray, KMPSearchAlgorithm.computeTable(byArray));
            long l3 = l2 == -1L ? -1L : l + l2;
            return l3;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public long position(Blob blob, long l) throws SQLException {
        if (l < 1L) {
            throw Util.outOfRangeArgument("start: " + l);
        }
        long l2 = blob == null ? 0L : blob.length();
        if (l2 == 0L || l > this.length()) {
            return -1L;
        }
        if (l2 > Integer.MAX_VALUE) {
            throw Util.outOfRangeArgument("pattern.length(): " + l2);
        }
        byte[] byArray = blob instanceof JDBCBlob ? ((JDBCBlob)blob).data() : blob.getBytes(1L, (int)l2);
        return this.position(byArray, l);
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (byArray == null) {
            throw Util.nullArgument("bytes");
        }
        OutputStream outputStream = this.setBinaryStream(l);
        try {
            outputStream.write(byArray, n, n2);
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        return n2;
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SQLException {
        BufferedOutputStream bufferedOutputStream;
        if (l < 1L) {
            throw Util.invalidArgument("pos: " + l);
        }
        this.checkClosed();
        this.createFile();
        try {
            OutputStreamAdapter outputStreamAdapter = new OutputStreamAdapter(this.m_file, l - 1L){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCBlobFile.this.m_streams.remove(this);
                    }
                }
            };
            bufferedOutputStream = new BufferedOutputStream(outputStreamAdapter);
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        this.m_streams.add(bufferedOutputStream);
        return bufferedOutputStream;
    }

    @Override
    public void truncate(long l) throws SQLException {
        if (l < 0L) {
            throw Util.invalidArgument("len: " + l);
        }
        this.checkClosed();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.m_file, "rw");
            randomAccessFile.setLength(l);
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void free() throws SQLException {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        if (this.m_temp) {
            try {
                this.m_file.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_streams.isEmpty()) {
            this.m_streams = null;
            return;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.m_streams);
        this.m_streams.clear();
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            for (Object e : arrayList) {
                try {
                    Method method = e.getClass().getMethod("close", classArray);
                    method.invoke(e, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    throwable.printStackTrace();
                    if (throwable instanceof SQLException || throwable instanceof RuntimeException || throwable instanceof Exception || !(throwable instanceof Error)) continue;
                    throw (Error)throwable;
                    return;
                }
            }
        }
        finally {
            this.m_streams = null;
        }
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        InputStreamAdapter inputStreamAdapter;
        if (l < 1L) {
            throw Util.outOfRangeArgument("pos: " + l);
        }
        this.checkClosed();
        try {
            inputStreamAdapter = new InputStreamAdapter(this.m_file, l - 1L, l2){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCBlobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        this.m_streams.add(inputStreamAdapter);
        return inputStreamAdapter;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.free();
    }

    public JDBCBlobFile() throws SQLException {
        this.m_temp = true;
        try {
            this.m_file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            FileUtil.getFileUtil().deleteOnExit(this.m_file);
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
    }

    public JDBCBlobFile(File file) throws SQLException {
        try {
            this.m_file = file.getCanonicalFile();
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
    }

    private void checkIsFile() throws SQLException {
        boolean bl;
        boolean bl2;
        try {
            bl2 = this.m_file.isFile();
            bl = bl2 || this.m_file.exists();
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        if (!bl) {
            throw Util.invalidArgument("Does not exist: " + this.m_file);
        }
        if (!bl2) {
            throw Util.invalidArgument("Is not a file: " + this.m_file);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw Util.sqlException(1251);
        }
    }

    private void createFile() throws SQLException {
        try {
            if (!this.m_file.exists()) {
                FileUtil.getFileUtil().makeParentDirectories(this.m_file);
                this.m_file.createNewFile();
            }
        }
        catch (Exception exception) {
            throw Util.sqlException(exception);
        }
        this.checkIsFile();
    }

    static class InputStreamAdapter
    extends InputStream {
        private final FileInputStream m_fileInputStream;
        private final CountdownInputStream m_countdownInputStream;

        InputStreamAdapter(File file, long l, long l2) throws FileNotFoundException, IOException {
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (l < 0L) {
                throw new IllegalArgumentException("pos: " + l);
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("length: " + l2);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            if (l > 0L) {
                long l3 = fileInputStream.skip(l);
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            CountdownInputStream countdownInputStream = new CountdownInputStream(bufferedInputStream);
            countdownInputStream.setCount(l2);
            this.m_fileInputStream = fileInputStream;
            this.m_countdownInputStream = countdownInputStream;
        }

        @Override
        public int available() throws IOException {
            int n = this.m_fileInputStream.available();
            int n2 = this.m_countdownInputStream.available();
            return Math.min(n, n2);
        }

        @Override
        public int read() throws IOException {
            return this.m_countdownInputStream.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.m_countdownInputStream.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.m_countdownInputStream.read(byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return this.m_countdownInputStream.skip(l);
        }

        @Override
        public void close() throws IOException {
            this.m_countdownInputStream.close();
        }
    }

    protected static class OutputStreamAdapter
    extends OutputStream {
        private final RandomAccessFile m_randomAccessFile;

        public OutputStreamAdapter(File file, long l) throws FileNotFoundException, IOException {
            if (l < 0L) {
                throw new IllegalArgumentException("pos: " + l);
            }
            this.m_randomAccessFile = new RandomAccessFile(file, "rw");
            this.m_randomAccessFile.seek(l);
        }

        @Override
        public void write(int n) throws IOException {
            this.m_randomAccessFile.write(n);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.m_randomAccessFile.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.m_randomAccessFile.write(byArray, n, n2);
        }

        @Override
        public void flush() throws IOException {
            this.m_randomAccessFile.getFD().sync();
        }

        @Override
        public void close() throws IOException {
            this.m_randomAccessFile.close();
        }
    }
}

