/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.FocusPainter;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaPainterState;
import de.javasoft.plaf.synthetica.painter.UIKey;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.text.JTextComponent;

public class ScrollPanePainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.ScrollPanePainter";

    protected ScrollPanePainter() {
    }

    public static ScrollPanePainter getInstance() {
        return ScrollPanePainter.getInstance(null);
    }

    public static ScrollPanePainter getInstance(SynthContext synthContext) {
        SyntheticaComponentPainter syntheticaComponentPainter = (SyntheticaComponentPainter)instances.get(ScrollPanePainter.getPainterClassName(synthContext, ScrollPanePainter.class, UI_KEY));
        if (syntheticaComponentPainter == null) {
            syntheticaComponentPainter = ScrollPanePainter.getInstance(synthContext, ScrollPanePainter.class, UI_KEY);
        }
        return (ScrollPanePainter)syntheticaComponentPainter;
    }

    public void paintScrollPaneBackground(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Object object;
        Insets insets;
        boolean bl;
        UIKey uIKey;
        Boolean bl2;
        Serializable serializable;
        Serializable serializable2;
        boolean bl3;
        JScrollPane jScrollPane = (JScrollPane)synthContext.getComponent();
        if (jScrollPane.getViewport() == null || jScrollPane.getViewport().getView() == null || !SyntheticaLookAndFeel.isOpaque(jScrollPane)) {
            return;
        }
        Component component = jScrollPane.getViewport().getView();
        Border border = jScrollPane.getBorder();
        Border border2 = SyntheticaLookAndFeel.findDefaultBorder(border);
        boolean bl4 = border2 == null ? false : border2.getClass().getName().equals("javax.swing.plaf.synth.SynthBorder");
        boolean bl5 = component instanceof JTextComponent;
        if (bl5 && !SyntheticaLookAndFeel.isOpaque((JTextComponent)component)) {
            return;
        }
        if (!bl5 && !bl4) {
            if (component.isOpaque()) {
                this.fillBackground(jScrollPane, border, border2, bl4, component, graphics, component.getBackground(), n, n2, n3, n4);
            }
            return;
        }
        boolean bl6 = bl3 = border instanceof CompoundBorder && ((CompoundBorder)border).getInsideBorder() == border2;
        if (bl3) {
            serializable2 = border.getBorderInsets(jScrollPane);
            serializable = border2.getBorderInsets(jScrollPane);
            n += ((Insets)serializable2).left - ((Insets)serializable).left;
            n2 += ((Insets)serializable2).top - ((Insets)serializable).top;
            n3 -= ((Insets)serializable2).left - ((Insets)serializable).left + ((Insets)serializable2).right - ((Insets)serializable).right;
            n4 -= ((Insets)serializable2).top - ((Insets)serializable).top + ((Insets)serializable2).bottom - ((Insets)serializable).bottom;
        }
        if (!bl5) {
            Insets insets2;
            serializable2 = jScrollPane.getBackground();
            if (serializable2 instanceof UIResource) {
                serializable2 = component.getBackground();
            }
            if ((serializable = graphics.getColor()) == null || serializable != null && !((Color)serializable).equals(serializable2)) {
                if (bl4) {
                    this.fillBackground(jScrollPane, border, border2, bl4, component, graphics, (Color)serializable2, n, n2, n3, n4);
                } else {
                    this.fillBackground(jScrollPane, null, border2, bl4, component, graphics, (Color)serializable2, n, n2, n3, n4);
                    return;
                }
            }
            String string = null;
            string = component.isEnabled() ? SyntheticaLookAndFeel.getString("Synthetica.scrollPane.border", jScrollPane) : SyntheticaLookAndFeel.getString("Synthetica.scrollPane.border.disabled", jScrollPane);
            Insets insets3 = insets2 = SyntheticaLookAndFeel.getInsets("Synthetica.scrollPane.border.insets", jScrollPane);
            ImagePainter imagePainter = new ImagePainter(graphics, n, n2, n3, n4, string, insets2, insets3, 0, 0);
            imagePainter.drawBorder();
            return;
        }
        serializable2 = (JTextComponent)component;
        serializable = ((Component)serializable2).getBackground();
        boolean bl7 = serializable == null || serializable instanceof ColorUIResource;
        boolean bl8 = SyntheticaLookAndFeel.getBoolean("Synthetica.scrollPane.keepLockedBorderIfColored", (Component)serializable2);
        boolean bl9 = ((Component)serializable2).isEnabled();
        boolean bl10 = !((JTextComponent)serializable2).isEditable();
        String string = "textField";
        if (serializable2 instanceof JTextArea) {
            string = "textArea";
        } else if (serializable2 instanceof JEditorPane) {
            string = "editorPane";
        } else if (serializable2 instanceof JTextPane) {
            string = "textPane";
        }
        int n5 = bl10 ? SyntheticaState.State.LOCKED.toInt() : 0;
        SyntheticaPainterState syntheticaPainterState = new SyntheticaPainterState(synthContext, n5 |= !bl9 ? SyntheticaState.State.DISABLED.toInt() : 0, false);
        if (!bl7 && !bl8) {
            syntheticaPainterState.resetState(SyntheticaState.State.LOCKED);
        }
        if ((bl2 = (Boolean)SyntheticaLookAndFeel.get((uIKey = new UIKey(String.valueOf(string) + ".border", syntheticaPainterState)).get("fillBackground"), (Component)serializable2)) == null || bl2.booleanValue()) {
            this.fillBackground(jScrollPane, border, border2, bl4, (Component)serializable2, graphics, (Color)serializable, n, n2, n3, n4);
        }
        boolean bl11 = bl = SyntheticaLookAndFeel.get(uIKey.get(), (Component)serializable2) != null;
        if (bl10 && !bl) {
            syntheticaPainterState.resetState(SyntheticaState.State.LOCKED);
            uIKey = new UIKey(String.valueOf(string) + ".border", syntheticaPainterState);
        }
        boolean bl12 = bl = SyntheticaLookAndFeel.get(uIKey.get(), (Component)serializable2) != null;
        if (!bl) {
            uIKey = new UIKey("scrollPane.border", syntheticaPainterState);
        }
        boolean bl13 = SyntheticaLookAndFeel.getBoolean(uIKey.get("solid"), (Component)serializable2);
        String string2 = SyntheticaLookAndFeel.getString(uIKey.get(), (Component)serializable2);
        Insets insets4 = SyntheticaLookAndFeel.getInsets(uIKey.get("insets"), (Component)serializable2);
        Insets insets5 = insets = insets4 == null ? SyntheticaLookAndFeel.getInsets("Synthetica.scrollPane.border.insets", (Component)serializable2) : insets4;
        if (!bl4) {
            object = jScrollPane.getInsets();
            n += ((Insets)object).left;
            n2 += ((Insets)object).top;
            n3 += -((Insets)object).left - ((Insets)object).right;
            n4 += -((Insets)object).top - ((Insets)object).bottom;
            insets5 = new Insets(0, 0, 0, 0);
        }
        object = new ImagePainter((JComponent)serializable2, graphics, n, n2, n3, n4, string2, insets, insets5, 0, 0);
        if (bl13) {
            ((ImagePainter)object).draw();
        } else {
            ((ImagePainter)object).drawBorder();
        }
    }

    public void paintScrollPaneBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        JScrollPane jScrollPane = (JScrollPane)synthContext.getComponent();
        if (jScrollPane.getViewport() == null || jScrollPane.getViewport().getView() == null) {
            return;
        }
        Component component = jScrollPane.getViewport().getView();
        boolean bl = SyntheticaLookAndFeel.getBoolean("Synthetica.focus.textComponents.enabled", component, true);
        boolean bl2 = SyntheticaLookAndFeel.getBoolean("Synthetica.focus.scrollPane.enabled", component, true);
        if (component.hasFocus() && (!(component instanceof JTextComponent) && bl2 || component instanceof JTextComponent && bl)) {
            FocusPainter.paintFocus("focus.scrollPane", synthContext, graphics, n, n2, n3, n4);
        }
    }

    private void fillBackground(JScrollPane jScrollPane, Border border, Border border2, boolean bl, Component component, Graphics graphics, Color color, int n, int n2, int n3, int n4) {
        Color color2;
        Object object;
        if (color instanceof ColorUIResource && component instanceof JTextComponent && (!((JTextComponent)(object = (JTextComponent)component)).isEditable() || !((Component)object).isEnabled())) {
            if (!((JTextComponent)object).isEditable()) {
                color2 = null;
                if (object instanceof JTextArea) {
                    color2 = SyntheticaLookAndFeel.getColor("Synthetica.textArea.lockedColor", (Component)object);
                } else if (object instanceof JTextPane) {
                    color2 = SyntheticaLookAndFeel.getColor("Synthetica.textPane.lockedColor", (Component)object);
                } else if (object instanceof JEditorPane) {
                    color2 = SyntheticaLookAndFeel.getColor("Synthetica.editorPane.lockedColor", (Component)object);
                }
                if (color2 == null && !((Component)object).isEnabled()) {
                    color2 = this.getDisabledBackgroundColor((JTextComponent)object);
                }
                if (color2 != null) {
                    color = color2;
                }
            } else if (!((Component)object).isEnabled()) {
                color = this.getDisabledBackgroundColor((JTextComponent)object);
            }
        }
        object = (Graphics2D)graphics;
        color2 = ((Graphics)object).getColor();
        ((Graphics)object).setColor(color);
        Insets insets = jScrollPane.getInsets();
        if (border == null || insets.equals(new Insets(0, 0, 0, 0))) {
            ((Graphics)object).fillRect(n, n2, n3, n4);
        } else if (!bl) {
            graphics.fillRect(n + insets.left, n2 + insets.top, n3 - insets.left - insets.right, n4 - insets.top - insets.bottom);
        } else {
            RenderingHints renderingHints = ((Graphics2D)object).getRenderingHints();
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Insets insets2 = SyntheticaLookAndFeel.getInsets("Synthetica.scrollPane.border.fillInsets", (Component)jScrollPane, false);
            int n5 = SyntheticaLookAndFeel.getInt("Synthetica.scrollPane.border.arcWidth", jScrollPane, 8);
            int n6 = SyntheticaLookAndFeel.getInt("Synthetica.scrollPane.border.arcHeight", jScrollPane, 8);
            ((Graphics)object).fillRoundRect(n + insets2.left, n2 + insets2.top, n3 - insets2.left - insets2.right, n4 - insets2.top - insets2.bottom, n5, n6);
            ((Graphics2D)object).setRenderingHints(renderingHints);
        }
        ((Graphics)object).setColor(color2);
    }

    private Color getDisabledBackgroundColor(JTextComponent jTextComponent) {
        Color color = null;
        if (jTextComponent instanceof JTextArea) {
            color = SyntheticaLookAndFeel.getColor("Synthetica.textArea.disabledColor", jTextComponent);
        } else if (jTextComponent instanceof JTextPane) {
            color = SyntheticaLookAndFeel.getColor("Synthetica.textPane.disabledColor", jTextComponent);
        } else if (jTextComponent instanceof JEditorPane) {
            color = SyntheticaLookAndFeel.getColor("Synthetica.editorPane.disabledColor", jTextComponent);
        }
        return color;
    }

    public Cacheable.ScaleType getCacheScaleType(String string) {
        return Cacheable.ScaleType.NINE_SQUARE;
    }

    public int getCacheHash(SynthContext synthContext, int n, int n2, int n3, String string) {
        JScrollPane jScrollPane = (JScrollPane)synthContext.getComponent();
        JComponent jComponent = (JComponent)jScrollPane.getViewport().getView();
        int n4 = super.getCacheHash(synthContext, n, n2, n3, string);
        if (jComponent != null) {
            boolean bl = jComponent.isEnabled();
            boolean bl2 = jComponent.hasFocus();
            boolean bl3 = jComponent instanceof JTextComponent ? !((JTextComponent)jComponent).isEditable() : false;
            Color color = jComponent.getBackground();
            Boolean bl4 = (Boolean)jComponent.getClientProperty("Synthetica.opaque");
            n4 = 31 * n4 + jComponent.getClass().hashCode();
            int n5 = n4 = color == null ? n4 : 31 * n4 + color.getRGB();
            n4 = bl4 == null ? n4 : 31 * n4 + (bl4 != false ? 0 : 1);
            n4 = 31 * n4 + (bl ? 0 : 1);
            n4 = 31 * n4 + (bl2 ? 0 : 1);
            n4 = 31 * n4 + (bl3 ? 0 : 1);
        }
        return n4;
    }

    public Insets getCacheScaleInsets(SynthContext synthContext, String string) {
        Insets insets;
        if (string.equals("paintScrollPaneBorder") && (insets = SyntheticaLookAndFeel.getInsets("Synthetica.scrollPane.border.insets", synthContext.getComponent())) != null) {
            return insets;
        }
        return super.getCacheScaleInsets(synthContext, string);
    }
}

