/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaMenuItemUI;
import de.javasoft.plaf.synthetica.painter.MenuPainter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicMenuUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthConstants;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;

public class SyntheticaMenuUI
extends BasicMenuUI
implements PropertyChangeListener,
SynthConstants {
    private String acceleratorDelimiter;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SyntheticaMenuUI();
    }

    protected void installDefaults() {
        this.updateStyle(this.menuItem);
    }

    protected void installListeners() {
        super.installListeners();
        this.menuItem.addPropertyChangeListener(this);
    }

    private void updateStyle(JMenuItem jMenuItem) {
        SynthStyle synthStyle = this.getStyle(jMenuItem);
        SynthContext synthContext = this.getContext((JComponent)jMenuItem, 1);
        String string = this.getPropertyPrefix();
        synthStyle.installDefaults(synthContext);
        this.defaultTextIconGap = synthStyle.getInt(synthContext, String.valueOf(string) + ".textIconGap", 4);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            Insets insets = (Insets)synthStyle.get(synthContext, String.valueOf(string) + ".margin");
            if (insets == null) {
                insets = new InsetsUIResource(0, 0, 0, 0);
            }
            this.menuItem.setMargin(insets);
        }
        this.acceleratorDelimiter = synthStyle.getString(synthContext, String.valueOf(string) + ".acceleratorDelimiter", "+");
        this.arrowIcon = synthStyle.getIcon(synthContext, String.valueOf(string) + ".arrowIcon");
        this.checkIcon = synthStyle.getIcon(synthContext, String.valueOf(string) + ".checkIcon");
        ((JMenu)this.menuItem).setDelay(synthStyle.getInt(synthContext, String.valueOf(string) + ".delay", 200));
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener(this);
    }

    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon icon, Icon icon2, int n) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthContext synthContext2 = this.getContext(jComponent, Region.MENU_ITEM_ACCELERATOR);
        Dimension dimension = SyntheticaMenuItemUI.getPreferredMenuItemSize(synthContext, synthContext2, this.useCheckAndArrow(), jComponent, icon, icon2, n, this.acceleratorDelimiter);
        return dimension;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        MenuPainter.getInstance(synthContext).paintMenuBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
    }

    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        MenuPainter.getInstance(synthContext).paintMenuBorder(synthContext, graphics, n, n2, n3, n4);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
    }

    private void paint(SynthContext synthContext, Graphics graphics) {
        SynthStyle synthStyle = synthContext.getStyle();
        String string = this.getPropertyPrefix();
        Icon icon = synthStyle.getIcon(synthContext, String.valueOf(string) + ".arrowIcon");
        Icon icon2 = synthStyle.getIcon(synthContext, String.valueOf(string) + ".checkIcon");
        SynthContext synthContext2 = this.getContext((JComponent)this.menuItem, Region.MENU_ITEM_ACCELERATOR);
        SyntheticaMenuItemUI.paint(synthContext, synthContext2, graphics, icon2, icon, this.useCheckAndArrow(), this.acceleratorDelimiter, this.defaultTextIconGap);
    }

    private boolean useCheckAndArrow() {
        return !((JMenu)this.menuItem).isTopLevelMenu();
    }

    private SynthStyle getStyle(JComponent jComponent) {
        return SynthLookAndFeel.getStyle(jComponent, this.getRegion(jComponent));
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return this.getContext(jComponent, this.getRegion(jComponent), n);
    }

    private SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n) {
        SynthStyle synthStyle = SynthLookAndFeel.getStyle(jComponent, region);
        SynthContext synthContext = new SynthContext(jComponent, region, synthStyle, n);
        return synthContext;
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent) {
        int n = 0;
        if (!jComponent.isEnabled()) {
            return 8;
        }
        n = this.menuItem.isArmed() ? 2 : (jComponent.isEnabled() ? (jComponent.isFocusOwner() ? 257 : 1) : 8);
        if (this.menuItem.isSelected()) {
            n |= 0x200;
        }
        return n;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SyntheticaLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JMenu)propertyChangeEvent.getSource());
        }
    }
}

