/*
 * Decompiled with CFR 0.152.
 */
package snaq.db;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import snaq.db.ConnectionPool;
import snaq.db.ConnectionValidator;
import snaq.db.PasswordDecoder;
import snaq.util.LogUtil;

public final class ConnectionPoolManager
extends LogUtil
implements Comparable {
    private static final String PROPERTIES_INSTANCE_KEY = "PROPERTIES_INSTANCE";
    private static final String DEFAULT_PROPERTIES_FILE = "/dbpool.properties";
    private static Hashtable managers = new Hashtable();
    private static ArrayList drivers = new ArrayList();
    private boolean released = false;
    private HashMap pools = new HashMap();
    protected int clients;
    private Object source;
    private Object key;
    static /* synthetic */ Class class$snaq$db$ConnectionPoolManager;

    private ConnectionPoolManager(Properties properties, Object object) {
        this.source = object;
        this.init(properties);
    }

    public String toString() {
        if (this.source instanceof String) {
            return "ConnectionPoolManager [CLASSPATH resource:" + this.source + "]";
        }
        if (this.source instanceof File) {
            return "ConnectionPoolManager [File:" + ((File)this.source).getAbsolutePath() + "]";
        }
        if (this.source instanceof Properties) {
            return "ConnectionPoolManager [Properties]";
        }
        return "ConnectionPoolManager [Unknown]";
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(((ConnectionPoolManager)object).toString());
    }

    public static Enumeration instances() {
        return Collections.enumeration(ConnectionPoolManager.getInstances());
    }

    public static Set getInstances() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(managers.values());
        return hashSet;
    }

    public static synchronized ConnectionPoolManager getInstance(String string) throws IOException {
        ConnectionPoolManager connectionPoolManager;
        String string2 = string.startsWith("/") ? string : "/" + string;
        Object v = managers.get(string2);
        ConnectionPoolManager connectionPoolManager2 = connectionPoolManager = v != null ? (ConnectionPoolManager)v : null;
        if (connectionPoolManager == null || connectionPoolManager.isReleased()) {
            connectionPoolManager = new ConnectionPoolManager(ConnectionPoolManager.loadProperties(string2), string);
            connectionPoolManager.key = string2;
            managers.put(connectionPoolManager.key, connectionPoolManager);
        }
        ++connectionPoolManager.clients;
        return connectionPoolManager;
    }

    public static synchronized ConnectionPoolManager getInstance(File file) throws IOException {
        ConnectionPoolManager connectionPoolManager;
        Object v = managers.get(file);
        ConnectionPoolManager connectionPoolManager2 = connectionPoolManager = v != null ? (ConnectionPoolManager)v : null;
        if (connectionPoolManager == null || connectionPoolManager.isReleased()) {
            try {
                connectionPoolManager = new ConnectionPoolManager(ConnectionPoolManager.loadProperties(file), file);
                connectionPoolManager.key = file;
                managers.put(connectionPoolManager.key, connectionPoolManager);
            }
            catch (IOException iOException) {
                if (iOException instanceof FileNotFoundException) {
                    System.err.println("Unable to find the properties file " + file.getAbsolutePath());
                } else {
                    System.err.println("Error loading the properties file " + file.getAbsolutePath());
                }
                iOException.printStackTrace();
                return null;
            }
        }
        ++connectionPoolManager.clients;
        return connectionPoolManager;
    }

    public static synchronized ConnectionPoolManager getInstance() throws IOException {
        ConnectionPoolManager connectionPoolManager;
        Object v = managers.get(PROPERTIES_INSTANCE_KEY);
        ConnectionPoolManager connectionPoolManager2 = connectionPoolManager = v != null ? (ConnectionPoolManager)v : null;
        if (connectionPoolManager != null && !connectionPoolManager.released) {
            ++connectionPoolManager.clients;
        } else {
            connectionPoolManager = ConnectionPoolManager.getInstance(DEFAULT_PROPERTIES_FILE);
        }
        return connectionPoolManager;
    }

    public static synchronized void createInstance(Properties properties) {
        ConnectionPoolManager connectionPoolManager;
        Object v = managers.get(DEFAULT_PROPERTIES_FILE);
        ConnectionPoolManager connectionPoolManager2 = connectionPoolManager = v != null ? (ConnectionPoolManager)v : null;
        if (connectionPoolManager != null && !connectionPoolManager.isReleased()) {
            throw new RuntimeException("Default properties file instance already exists");
        }
        connectionPoolManager = new ConnectionPoolManager(properties, properties);
        connectionPoolManager.key = PROPERTIES_INSTANCE_KEY;
        managers.put(connectionPoolManager.key, connectionPoolManager);
    }

    private static Properties loadProperties(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getAbsolutePath() + " does not exist");
        }
        if (file.isDirectory()) {
            throw new IOException("Error accessing properties file - " + file.getAbsolutePath() + " is a directory");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        Properties properties = new Properties();
        properties.load(fileInputStream);
        ((InputStream)fileInputStream).close();
        return properties;
    }

    private static Properties loadProperties(String string) throws IOException {
        InputStream inputStream = (class$snaq$db$ConnectionPoolManager == null ? (class$snaq$db$ConnectionPoolManager = ConnectionPoolManager.class$("snaq.db.ConnectionPoolManager")) : class$snaq$db$ConnectionPoolManager).getResourceAsStream(string);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException iOException) {
            System.err.println("Unable to load the properties file. Make sure " + string + " is in the CLASSPATH.");
            iOException.printStackTrace();
            throw iOException;
        }
        return properties;
    }

    private void init(Properties properties) {
        String string = properties.getProperty("logfile", "ConnectionPoolManager.log");
        String string2 = properties.getProperty("dateformat", "EEE MMM dd hh:mm:ss.SSS ZZZ yyyy");
        try {
            this.setDateFormat(new SimpleDateFormat(string2));
            this.setLog(new FileOutputStream(string, true));
        }
        catch (IOException iOException) {
            System.err.println("Can't open the log file: " + string);
        }
        this.loadDrivers(properties);
        this.createPools(properties);
    }

    private void loadDrivers(Properties properties) {
        String string = properties.getProperty("drivers");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",: \t\n\r\f");
        Enumeration<Driver> enumeration = DriverManager.getDrivers();
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken().trim();
            try {
                Object object;
                boolean bl = false;
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement().getClass().getName();
                    if (!((String)object).equals(string2)) continue;
                    bl = true;
                }
                if (bl) continue;
                object = (Driver)Class.forName(string2).newInstance();
                DriverManager.registerDriver((Driver)object);
                drivers.add(object);
                this.log("Registered JDBC driver " + string2);
            }
            catch (Exception exception) {
                this.log("Unable to register JDBC driver: " + string2 + ", Exception: " + exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPools(Properties properties) {
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            int n;
            int n2;
            int n3;
            int n4;
            String string = (String)iterator.next();
            if (!string.endsWith(".url")) continue;
            String string2 = string.substring(0, string.lastIndexOf("."));
            String string3 = properties.getProperty(string2 + ".url");
            if (string3 == null) {
                this.log("No URL specified for " + string2);
                continue;
            }
            String string4 = properties.getProperty(string2 + ".user");
            string4 = string4 != null ? string4.trim() : string4;
            String string5 = properties.getProperty(string2 + ".password");
            string5 = string5 != null ? string5.trim() : string5;
            String string6 = properties.getProperty(string2 + ".maxpool", "0").trim();
            String string7 = properties.getProperty(string2 + ".maxconn", "0").trim();
            String string8 = properties.getProperty(string2 + ".init", "0").trim();
            String string9 = properties.getProperty(string2 + ".expiry", "0").trim();
            String string10 = properties.getProperty(string2 + ".validator");
            String string11 = properties.getProperty(string2 + ".decoder");
            String string12 = properties.getProperty(string2 + ".logfile");
            String string13 = properties.getProperty(string2 + ".dateformat");
            string10 = string10 != null ? string10.trim() : string10;
            boolean bl = properties.getProperty(string2 + ".cache", "true").trim().equalsIgnoreCase("false");
            boolean bl2 = properties.getProperty(string2 + ".async", "false").trim().equalsIgnoreCase("true");
            boolean bl3 = properties.getProperty(string2 + ".debug", "false").trim().equalsIgnoreCase("true");
            Properties properties2 = new Properties();
            String string14 = string2 + ".prop.";
            Iterator<Object> iterator2 = properties.keySet().iterator();
            while (iterator2.hasNext()) {
                String string15 = (String)iterator2.next();
                if (!string15.startsWith(string14)) continue;
                properties2.setProperty(string15.substring(string14.length()), properties.getProperty(string15));
            }
            if (!properties2.isEmpty() && string4 != null && !string4.equals("")) {
                properties2.setProperty("user", string4);
                properties2.setProperty("password", string5);
            } else {
                properties2 = null;
            }
            try {
                n4 = Integer.valueOf(string6);
            }
            catch (NumberFormatException numberFormatException) {
                this.log("Invalid maxpool value " + string6 + " for " + string2);
                n4 = 0;
            }
            try {
                n3 = Integer.valueOf(string7);
            }
            catch (NumberFormatException numberFormatException) {
                this.log("Invalid maxconn value " + string7 + " for " + string2);
                n3 = 0;
            }
            try {
                n2 = Integer.valueOf(string8);
            }
            catch (NumberFormatException numberFormatException) {
                this.log("Invalid initsize value " + string8 + " for " + string2);
                n2 = 0;
            }
            try {
                n = Integer.valueOf(string9);
            }
            catch (NumberFormatException numberFormatException) {
                this.log("Invalid expiry value " + string9 + " for " + string2);
                n = 0;
            }
            n4 = Math.max(n4, 0);
            n3 = Math.max(n3, 0);
            if (n3 > 0) {
                n3 = Math.max(n3, n4);
            }
            n2 = Math.min(Math.max(n2, 0), n4);
            n = Math.max(n, 0);
            ConnectionPool connectionPool = null;
            connectionPool = properties2 != null ? new ConnectionPool(string2, n4, n3, n * 1000, string3, properties2) : new ConnectionPool(string2, n4, n3, n * 1000, string3, string4, string5);
            try {
                object = new SimpleDateFormat(string13);
                connectionPool.setDateFormat((DateFormat)object);
            }
            catch (Exception exception) {
                this.log("Invalid dateformat string specified: " + string13);
            }
            if (string12 != null && !string12.equals("")) {
                object = new File(string12);
                if (((File)object).exists() && ((File)object).isDirectory()) {
                    this.log("Invalid logfile specified for pool " + string2 + " - specified file is a directory");
                } else if (!((File)object).exists() && !((File)object).mkdirs()) {
                    this.log("Invalid logfile specified for pool " + string2 + " - cannot create file " + ((File)object).getAbsolutePath());
                }
                try {
                    connectionPool.setLog(new FileOutputStream((File)object, true));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log(fileNotFoundException, "Invalid logfile specified for pool " + string2);
                    connectionPool.setLog(this.getLogStream());
                }
            } else {
                connectionPool.setLog(this.getLogStream());
            }
            if (bl3) {
                this.log("Enabling debug info on pool " + string2);
            }
            connectionPool.setDebug(bl3);
            if (bl) {
                this.log("Disabling caching on pool " + string2);
            }
            connectionPool.setCaching(!bl);
            if (bl2) {
                this.log("Enabling asynchronous destruction on pool " + string2);
            }
            connectionPool.setAsyncDestroy(bl2);
            if (string10 != null && !string10.equals("")) {
                try {
                    object = Class.forName(string10).newInstance();
                    if (object instanceof ConnectionValidator) {
                        connectionPool.setValidator((ConnectionValidator)object);
                    }
                }
                catch (Exception exception) {
                    this.log("Unable to instantiate validator class for pool " + string2 + ": " + string10);
                }
            }
            if (string11 != null && !string11.equals("")) {
                try {
                    object = Class.forName(string11).newInstance();
                    if (object instanceof PasswordDecoder) {
                        connectionPool.setPasswordDecoder((PasswordDecoder)object);
                    }
                }
                catch (Exception exception) {
                    this.log("Unable to instantiate password decoder class for pool " + string2 + ": " + string11);
                }
            }
            object = this.pools;
            synchronized (object) {
                this.pools.put(string2, connectionPool);
            }
            object = "pool=" + connectionPool.getPoolSize() + ",max=" + connectionPool.getMaxSize() + ",expiry=";
            object = (String)object + (connectionPool.getExpiryTime() == 0L ? "none" : connectionPool.getExpiryTime() + "ms");
            this.log("Initialized pool " + string2 + " (" + (String)object + ")");
            if (n2 <= 0) continue;
            connectionPool.init(n2);
        }
    }

    public ConnectionPool getPool(String string) {
        if (this.released) {
            throw new RuntimeException("Pool manager no longer valid for use");
        }
        return (ConnectionPool)this.pools.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionPool[] getPools() {
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            return this.pools.values().toArray(new ConnectionPool[0]);
        }
    }

    public Connection getConnection(String string) throws SQLException {
        if (this.released) {
            throw new RuntimeException("Pool manager no longer valid for use");
        }
        ConnectionPool connectionPool = (ConnectionPool)this.pools.get(string);
        if (connectionPool != null) {
            return connectionPool.getConnection();
        }
        return null;
    }

    public Connection getConnection(String string, long l) throws SQLException {
        if (this.released) {
            throw new RuntimeException("Pool manager no longer valid for use");
        }
        ConnectionPool connectionPool = (ConnectionPool)this.pools.get(string);
        if (connectionPool != null) {
            return connectionPool.getConnection(l);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        Object object;
        if (--this.clients > 0) {
            return;
        }
        this.released = true;
        Object object2 = this.pools;
        synchronized (object2) {
            object = this.pools.values().iterator();
            while (object.hasNext()) {
                ConnectionPool connectionPool = (ConnectionPool)object.next();
                connectionPool.releaseForcibly();
            }
        }
        if (managers.size() == 1) {
            object2 = drivers.iterator();
            while (object2.hasNext()) {
                object = (Driver)object2.next();
                try {
                    DriverManager.deregisterDriver((Driver)object);
                    this.log("Deregistered JDBC driver " + object.getClass().getName());
                }
                catch (SQLException sQLException) {
                    this.log(sQLException, "Can't deregister JDBC driver: " + object.getClass().getName());
                }
            }
        }
        managers.remove(this.key);
        super.close();
    }

    public synchronized boolean isReleased() {
        return this.released;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setValidator(ConnectionValidator connectionValidator) {
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            if (this.pools != null) {
                Iterator iterator = this.pools.values().iterator();
                while (iterator.hasNext()) {
                    ((ConnectionPool)iterator.next()).setValidator(connectionValidator);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLog(OutputStream outputStream) {
        super.setLog(outputStream);
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            if (this.pools != null) {
                Iterator iterator = this.pools.values().iterator();
                while (iterator.hasNext()) {
                    ((ConnectionPool)iterator.next()).setLog(outputStream);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLog(PrintStream printStream) {
        super.setLog(printStream);
        HashMap hashMap = this.pools;
        synchronized (hashMap) {
            if (this.pools != null) {
                Iterator iterator = this.pools.values().iterator();
                while (iterator.hasNext()) {
                    ((ConnectionPool)iterator.next()).setLog(printStream);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

