﻿<%@page contentType="text/html; charset=utf-8"%>
<%@page import="java.sql.*" %>
<%@page import="org.acts.common.*" %>
<%@page import="org.acts.common.html.*" %>
<%@page import="org.acts.member.*" %>
<%@page import="org.acts.venue.*" %>
<%@include file="../include/check_login.jsp" %>

<%@include file="../include/header.jsp" %>
<%msbean.setCur_menu_node(MenuItem.VENUE__REQUEST);%>
<link rel="stylesheet" type="text/css" href="../script/ext/resources/css/ext-all.css">
<script type="text/javascript" src="../script/ext/adapter/ext/ext-base.js"></script>
<script type="text/javascript" src="../script/ext/ext-all.js"></script>
<script type="text/javascript">
<%
Timestamp requireMaxDate=Config.getT(Config.venueRequestMaxDate);
Timestamp requireMinDate=TimeUtil.getCurrentDate();
if(msbean.getIData("r_venue_seq")!=-1){
	Venue venue=new Venue(msbean.getIData("r_venue_seq"));
	requireMinDate=TimeUtil.adjustDate(TimeUtil.getCurrentDate(),venue.getRequest_before());
}
%>
function changeVenue(){
	opSubmit("venue.VenueModuleAction.request.changeVenue");
}
function addItem(){
	var f=document.stdform;
	if(f.r_vne_seq.value==""){
		alert("<%=Lang.set("請選擇使用設備")%>");
		return;
	}
	for(var i=0;i<<%=(msbean.getIData("r_item_index")+1)%>;i++){
		if(getEValue("r_vne_seq"+i)==f.r_vne_seq.value){
			alert("<%=Lang.set("所選的設備已經加入")%>");
			return;
		}
	}
	setValidateRequired(false);
	opSubmit("venue.VenueModuleAction.request.addItem");
}
function delItem(i){
	var f=document.stdform;
	f.r_item_del.value=i;
	opSubmit("venue.VenueModuleAction.request.delItem");
}
function update(){
	var f=document.stdform;
	var vf=LiveValidationForm.getInstance(f);
	if(!vf.validateAll()) return false;
		
	if(f.r_user_num.value==0){
		alert("<%=Lang.set("使用人數必須大於零")%>");
		return false;
	}
	
	var startDate=getDateByString(f.r_start_date.value);
	var minDate=getDateByString("<%=TimeUtil.getStringByDate(requireMinDate)%>");
	var maxDate=getDateByString("<%=TimeUtil.getStringByDate(requireMaxDate)%>");
	if(startDate<minDate || maxDate<startDate){
		alert("<%=Lang.set(
			"使用日期範圍必須介於"
			+TimeUtil.getStringByDate(requireMinDate)
			+"至"
			+TimeUtil.getStringByDate(requireMaxDate)
			)%>");
		return false;
	}
	var time_err=false;
	if(parseInt(f.r_start_hour.value)>parseInt(f.r_end_hour.value)){
		time_err=true;
	}
	if(parseInt(f.r_start_hour.value)==parseInt(f.r_end_hour.value)){
		if(parseInt(f.r_start_minute.value)>=parseInt(f.r_end_minute.value)){
			time_err=true;
		}
	}
	if(time_err){
		alert("<%=Lang.set("使用時間範圍不正確")%>");
		return false;
	}
	
	opSubmit("venue.VenueModuleAction.request.update");
}
</script>
<%@include file="../include/body.jsp" %>
<%
int gVenueSeq=msbean.getIData("r_venue_seq");
SelectMenu venueSM=new SelectMenu("r_venue_seq",Venue.getVenueNames(),"name","venue_seq",gVenueSeq);
venueSM.setPleaseSelItem();
venueSM.addAttribute("onchange=changeVenue()");
venueSM.validate("Validate.Presence");

int gMemberGroupSeq=msbean.getIData("r_member_group_seq");
SelectMenu mgSM=new SelectMenu("r_member_group_seq",MemberGroup.getGroupsByMemberSeq(msbean.getMember_seq()),"name","member_group_seq",gMemberGroupSeq);
mgSM.setPleaseSelItem();
mgSM.validate("Validate.Presence");

ExtJs extjs=new ExtJs();
ExtDateTextBox start_dateDTB=new ExtDateTextBox("r_start_date",msbean.getSData("r_start_date"),"",extjs);
start_dateDTB.setMinDate(requireMinDate);
start_dateDTB.setMaxDate(requireMaxDate);

Timestamp venueStartTime=Config.getT(Config.venueStartTime);
Timestamp venueEndTime=Config.getT(Config.venueEndTime);

RecordList hours=new RecordList(new String[]{"hour"});
for(int i=TimeUtil.getHour(venueStartTime);i<=TimeUtil.getHour(venueEndTime);i++){
	hours.addItem(new String[]{Tools.padZero(String.valueOf(i),2)});
}
SelectMenu startHourSM=new SelectMenu("r_start_hour",hours,"hour","hour",msbean.getSData("r_start_hour"));
startHourSM.setNilItemEnable(false);
SelectMenu endHourSM=new SelectMenu("r_end_hour",hours,"hour","hour",msbean.getSData("r_end_hour"));
endHourSM.setNilItemEnable(false);

RecordList minutes=new RecordList(new String[]{"minute"});
minutes.addItem(new String[]{"00"});
minutes.addItem(new String[]{"15"});
minutes.addItem(new String[]{"30"});
minutes.addItem(new String[]{"45"});
SelectMenu startMinuteSM=new SelectMenu("r_start_minute",minutes,"minute","minute",msbean.getSData("r_start_minute"));
startMinuteSM.setNilItemEnable(false);
SelectMenu endMinuteSM=new SelectMenu("r_end_minute",minutes,"minute","minute",msbean.getSData("r_end_minute"));
endMinuteSM.setNilItemEnable(false);

if(msbean.getIData("r_item_index")>=0){
	start_dateDTB.addAttribute(",disabled: true");
	startHourSM.addAttribute("disabled=true");
	endHourSM.addAttribute("disabled=true");
	startMinuteSM.addAttribute("disabled=true");
	endMinuteSM.addAttribute("disabled=true");
}

int capacity=new Venue(gVenueSeq).getUser_capacity();
TextBox max_userTF=new TextBox("max_user",String.valueOf(capacity),6,5);
max_userTF.addAttribute("disabled=true");

TextBox user_numTF=new TextBox("r_user_num",msbean.getIData("r_user_num"),6,5);
user_numTF.validate("Validate.Presence");
user_numTF.validate("Validate.Numericality,{onlyInteger: true}");
//at beginning, no venue is selected, the max user is 0, you should allow this situation
user_numTF.validate(" Validate.Numericality,{minimum:"+(capacity==0?0:1)+",maximum:"+capacity+"}");

SelectMenu purposeSM=new SelectMenu(
	"r_purpose"
	,MasterCode.getCodes(MasterGroup.VENUE_REQUEST_PURPOSE)
	,"name"
	,"code"
	,msbean.getSData("r_purpose")
	);
purposeSM.setPleaseSelItem();
purposeSM.validate("Validate.Presence");

RecordList equipments=VenueRequest.getAvailableEquipments(
	gVenueSeq
	,msbean.getIData("r_venue_request_seq")
	,TimeUtil.getDateByString(msbean.getSData("r_start_date"),msbean.getSData("r_start_hour")+":"+msbean.getSData("r_start_minute"))
	,TimeUtil.getDateByString(msbean.getSData("r_start_date"),msbean.getSData("r_end_hour")+":"+msbean.getSData("r_end_minute"))
	);
SelectMenu equipmentSM=new SelectMenu("r_vne_seq",equipments,"name","venue_equipment_seq",-1);
equipmentSM.setPleaseSelItem();

HtmlTable t=new HtmlTable(new int[]{950});
t.addTitleCell(0,0,msbean.getCur_menu_node().getName());
t.toHtml(out);

t=new HtmlTable(new int[]{125,340,125,100,260});
t.addDescCell(0,0,"場地");
t.addDescCell(0,1,"使用群組");
t.addDescCell(0,2,"使用人數");
t.addDescCell(0,3,"備註");
t.addDescCell(0,4,"使用設備");

t.addLCell(1,0,venueSM);
t.addLCell(1,1,4,1,mgSM);
t.addLCell(1,2,user_numTF.toHtml()+" 人 (可容納 "+max_userTF.toHtml()+"人)");
t.addLCell(1,3,4,1,new TextBox("r_remark",msbean.getSData("r_remark"),100,1000));
t.addLCell(1,4,equipmentSM);

t.addDescCell(2,0,"使用日期");
t.addDescCell(2,2,"用途");
t.addRCell(2,4,3,1,(new Button("加入設備","addItem()")).toHtml());

t.addLCell(3,0,start_dateDTB);
t.addLCell(4,0,startHourSM.toHtml()+":"+startMinuteSM.toHtml()+" 至 "+endHourSM.toHtml()+":"+endMinuteSM.toHtml()+msbean.getSData("r_overlap_msg"));
t.addLCell(3,2,2,1,purposeSM);

t.toHtml(out);

if(msbean.getIData("r_item_index")>-1){
	int row=0;
	t=new HtmlTable(new int[]{605,100,80,100,50});
	
	t.addHeaderCell(0,row,"設備名稱");
	t.addHeaderCell(1,row,"總可用量");
	t.addHeaderCell(2,row,"數量");
	t.addHeaderCell(3,row,"單位");
	t.addHeaderCell(4,row,"刪除"
		+(new Hidden("r_item_del",-1)).toHtml()
		+(new Hidden("r_item_index",msbean.getIData("r_item_index"))).toHtml()
		);

	for(int i=0;i<msbean.getIData("r_item_index")+1;i++){
		int vne_seq=msbean.getIData("r_vne_seq"+i);
		int index=equipments.indexOf("venue_equipment_seq",vne_seq);
		String max_qty=String.valueOf(equipments.getBigDecimal("qty",index));
		
		TextBox vne_qtyTB=new TextBox("r_vne_qty"+i,msbean.getSData("r_vne_qty"+i),6,5);
		vne_qtyTB.validate("Validate.Presence");
		vne_qtyTB.validate("Validate.Numericality");
		vne_qtyTB.validate(" Validate.Numericality,{minimum:0,maximum:"+max_qty+"}");
		
		row++;
		t.addLCell(0,row,equipments.getS("name",index)+(new Hidden("r_vne_seq"+i,vne_seq)).toHtml());
		t.addRCell(1,row,max_qty);
		t.addRCell(2,row,vne_qtyTB);
		t.addLCell(3,row,equipments.getS("unit",index));
		t.addCCell(4,row,new Button("X","delItem("+i+")"));
	}

	t.toHtml(out);
}
extjs.toHtml(out);
%>
<center>
<%
if(!msbean.getSData("op").equals("venue.VenueModuleAction.request_record.readRequest")){
	(new Button("確定","update()")).toHtml(out);
}
%>
</center>
<%@include file="../include/footer.jsp" %>