/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PRAcroForm;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class concat_pdf {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("arguments: file1 [file2 ...] destfile");
        } else {
            try {
                int pageOffset = 0;
                ArrayList master = new ArrayList();
                String outFile = args[args.length - 1];
                Document document = null;
                PdfCopy writer = null;
                for (int f = 0; f < args.length - 1; ++f) {
                    PdfReader reader = new PdfReader(args[f]);
                    reader.consolidateNamedDestinations();
                    int n = reader.getNumberOfPages();
                    List bookmarks = SimpleBookmark.getBookmark(reader);
                    if (bookmarks != null) {
                        if (pageOffset != 0) {
                            SimpleBookmark.shiftPageNumbers(bookmarks, pageOffset, null);
                        }
                        master.addAll(bookmarks);
                    }
                    pageOffset += n;
                    System.out.println("There are " + n + " pages in " + args[f]);
                    if (f == 0) {
                        document = new Document(reader.getPageSizeWithRotation(1));
                        writer = new PdfCopy(document, (OutputStream)new FileOutputStream(outFile));
                        document.open();
                    }
                    int i = 0;
                    while (i < n) {
                        PdfImportedPage page = writer.getImportedPage(reader, ++i);
                        writer.addPage(page);
                        System.out.println("Processed page " + i);
                    }
                    PRAcroForm form = reader.getAcroForm();
                    if (form == null) continue;
                    writer.copyAcroForm(reader);
                }
                if (master.size() > 0) {
                    writer.setOutlines(master);
                }
                document.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

