/*
 * Decompiled with CFR 0.152.
 */
package util;

import database.DBUtil;
import java.sql.Timestamp;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import util.RecordList;

public class TimeUtil {
    public static Timestamp getTimestampByInput(String date) {
        return Timestamp.valueOf(String.valueOf(date) + " 00:00:00");
    }

    public static String getStringByDate(Timestamp t) {
        if (t == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        return df.format((Date)t, new StringBuffer(), new FieldPosition(2)).toString();
    }

    public static String getStringByTime(Timestamp t) {
        if (t == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        return df.format((Date)t, new StringBuffer(), new FieldPosition(2)).toString();
    }

    public static String getStringByTime12(Timestamp t) {
        if (t == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("ahh:mm");
        return df.format((Date)t, new StringBuffer(), new FieldPosition(2)).toString();
    }

    public static String getStringByDateTime(Timestamp t) {
        if (t == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        return df.format((Date)t, new StringBuffer(), new FieldPosition(2)).toString();
    }

    public static Timestamp getDateByString(String s) {
        if (TimeUtil.isValidDateString(s)) {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            df.setLenient(false);
            return new Timestamp(df.parse(s, new ParsePosition(0)).getTime());
        }
        return null;
    }

    public static Timestamp getDateByString(String date, String time) {
        if (TimeUtil.isValidDateString(date) && TimeUtil.isValidTimeString(time)) {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm");
            df.setLenient(false);
            return new Timestamp(df.parse(String.valueOf(date) + " " + time, new ParsePosition(0)).getTime());
        }
        return null;
    }

    public static Timestamp getDateByPeriod(String s) {
        if (TimeUtil.isValidPeriodString(s)) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
            df.setLenient(false);
            return new Timestamp(df.parse(s, new ParsePosition(0)).getTime());
        }
        return null;
    }

    public static boolean isValidDateString(String s) {
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        df.setLenient(false);
        return df.parse(s, new ParsePosition(0)) != null;
    }

    public static boolean isValidTimeString(String s) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        df.setLenient(false);
        return df.parse(s, new ParsePosition(0)) != null;
    }

    public static boolean isValidPeriodString(String s) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMM");
        df.setLenient(false);
        return df.parse(s, new ParsePosition(0)) != null;
    }

    public static Timestamp getCurrentDate() {
        String sql = "select now() as d from dual";
        RecordList r = DBUtil.run(sql);
        Timestamp d = r.getT("d", 0);
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        return Timestamp.valueOf(f.format(d));
    }

    public static Timestamp getCurrentTimestamp() {
        String sql = "select now() as d from dual";
        RecordList r = DBUtil.run(sql);
        Timestamp d = r.getT("d", 0);
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return Timestamp.valueOf(f.format(d));
    }

    public static Timestamp getLocalTimestamp() {
        Date d = new Date();
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return Timestamp.valueOf(f.format(d));
    }

    public static Timestamp adjustDate(Timestamp t, int day) {
        if (t == null) {
            return null;
        }
        long t1 = 86400000L;
        return new Timestamp(t.getTime() + (t1 *= (long)day));
    }

    public static Timestamp adjustMonth(Timestamp t, int month) {
        if (t == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(t);
        int year = c.get(1);
        int cur_month = c.get(2) + 1;
        int adjusted_month = cur_month + month;
        if (adjusted_month < 0) {
            year += adjusted_month / 12 - 1;
            adjusted_month = 12 + adjusted_month % 12;
        }
        SimpleDateFormat f = new SimpleDateFormat(String.valueOf(year) + "-" + TimeUtil.padZero(adjusted_month) + "-" + TimeUtil.padZero(c.get(5)) + " " + TimeUtil.padZero(c.get(11)) + ":" + TimeUtil.padZero(c.get(12)) + ":" + TimeUtil.padZero(c.get(13)));
        return Timestamp.valueOf(f.format(t));
    }

    public static Timestamp getMonthStartDay(Timestamp t) {
        if (t == null) {
            return null;
        }
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-01 00:00:00");
        return Timestamp.valueOf(f.format(t));
    }

    public static Timestamp getMonthEndDay(Timestamp t) {
        if (t == null) {
            return null;
        }
        return TimeUtil.adjustDate(TimeUtil.getMonthStartDay(TimeUtil.adjustMonth(t, 1)), -1);
    }

    public static int getMonth(Timestamp t) {
        if (t == null) {
            return 0;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(t);
        return c.get(2) + 1;
    }

    public static String getCheckPoint() {
        Date d = new Date();
        SimpleDateFormat f = new SimpleDateFormat("HH:mm:ss.SSS");
        return f.format(new Date());
    }

    public static String padZero(int s) {
        return s < 10 ? "0" + s : "" + s;
    }
}

