/*
 * Decompiled with CFR 0.152.
 */
package printout.xls;

import java.util.StringTokenizer;
import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.format.VerticalAlignment;
import jxl.write.DateFormat;
import jxl.write.NumberFormat;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import printout.xls.ExcelFormat;
import util.Tools;

public class ExcelCellFormat {
    public static String INT = "INT";
    public static String DOUBLE = "DOUBLE";
    public static String TIMESTAMP = "TIMESTAMP";
    public static String STRING = "STRING";
    private String g_Type;
    private String g_Formats;
    private WritableCellFormat g_CellFormat;

    public ExcelCellFormat(String type, String formats) {
        this.g_Type = type;
        this.g_Formats = formats;
        if (this.g_Type.equals(INT)) {
            this.g_CellFormat = new WritableCellFormat((DisplayFormat)new NumberFormat("#,##0"));
        } else if (this.g_Type.equals(DOUBLE)) {
            this.g_CellFormat = new WritableCellFormat((DisplayFormat)new NumberFormat("#,##0.00"));
        } else if (this.g_Type.equals(TIMESTAMP)) {
            this.g_CellFormat = new WritableCellFormat((DisplayFormat)new DateFormat("dd/MM/yyyy"));
            this.g_Formats = String.valueOf(ExcelFormat.AL) + this.g_Formats;
        } else {
            this.g_CellFormat = new WritableCellFormat();
        }
        this.setFormats();
    }

    public WritableCellFormat getCellFormat() {
        return this.g_CellFormat;
    }

    public void setWrap(boolean s) {
        try {
            this.g_CellFormat.setWrap(s);
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
    }

    private void setFormats() {
        StringTokenizer stoken = new StringTokenizer(String.valueOf(ExcelFormat.DEFAULT) + this.g_Formats, "%");
        WritableFont font = new WritableFont(this.g_CellFormat.getFont());
        try {
            while (stoken.hasMoreTokens()) {
                String style = String.valueOf(stoken.nextToken()) + "%";
                if (style.equals(ExcelFormat.BT)) {
                    this.g_CellFormat.setBorder(Border.TOP, BorderLineStyle.THIN);
                    continue;
                }
                if (style.equals(ExcelFormat.BB)) {
                    this.g_CellFormat.setBorder(Border.BOTTOM, BorderLineStyle.THIN);
                    continue;
                }
                if (style.equals(ExcelFormat.BD)) {
                    this.g_CellFormat.setBorder(Border.BOTTOM, BorderLineStyle.DOUBLE);
                    continue;
                }
                if (style.equals(ExcelFormat.WT)) {
                    this.g_CellFormat.setWrap(true);
                    continue;
                }
                if (style.equals(ExcelFormat.WF)) {
                    this.g_CellFormat.setWrap(false);
                    continue;
                }
                if (style.equals(ExcelFormat.FB)) {
                    font.setBoldStyle(WritableFont.BOLD);
                    continue;
                }
                if (style.equals(ExcelFormat.FI)) {
                    font.setItalic(true);
                    continue;
                }
                if (style.equals(ExcelFormat.AC)) {
                    this.g_CellFormat.setAlignment(Alignment.CENTRE);
                    continue;
                }
                if (style.equals(ExcelFormat.AL)) {
                    this.g_CellFormat.setAlignment(Alignment.LEFT);
                    continue;
                }
                if (style.equals(ExcelFormat.AR)) {
                    this.g_CellFormat.setAlignment(Alignment.RIGHT);
                    continue;
                }
                if (style.equals(ExcelFormat.AT)) {
                    this.g_CellFormat.setVerticalAlignment(VerticalAlignment.TOP);
                    continue;
                }
                if (style.equals(ExcelFormat.FCR)) {
                    font.setColour(Colour.RED);
                    continue;
                }
                if (!style.substring(0, 2).equals(ExcelFormat.FS)) continue;
                int font_size = Integer.parseInt(style.substring(2, style.length() - 1));
                font.setPointSize(font_size);
            }
        }
        catch (Exception e) {
            Tools.writeError(e);
        }
        this.g_CellFormat.setFont((FontRecord)font);
    }
}

