/*
 * Decompiled with CFR 0.152.
 */
package attendance;

import attendance.Activity;
import attendance.ActivityMemberGroup;
import attendance.Attendance;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import system.MasterCode;
import ui.AutoComboBoxNV;
import ui.DataDialog;
import ui.ScrollList;
import ui.ScrollList2;
import ui.TableLayout;
import util.ArrayUtil;
import util.RecordList;
import util.TimeUtil;
import util.Validation;
import util.WinUtil;
import venue.Venue;

public class AttendanceListDialog
extends DataDialog {
    private int g_Activity_seq = -1;
    private Activity g_Activity;
    private ScrollList itemSL;
    private RecordList g_Items;
    private ScrollList2 groupSL;
    private RecordList g_Amgs;
    private AutoComboBoxNV memberNV;
    private JButton exitB;
    private JButton saveB;
    private JButton deleteB;
    private JButton rearrangeB;

    public AttendanceListDialog(DataDialog dialog, int activity_seq) {
        super(dialog, "\u51fa\u5e2d\u8a18\u9304\u5217\u8868", false);
        this.g_Activity_seq = activity_seq;
        this.g_Activity = new Activity(activity_seq);
        this.g_Items = Attendance.getAttendanceList(activity_seq);
        this.g_Amgs = new ActivityMemberGroup(activity_seq).getItems();
        this.setLayout();
        this.setEventHandler();
        this.setVisible(true);
    }

    public void setLayout() {
        this.exitB = new JButton("\u96e2\u958b");
        this.saveB = new JButton("\u5132\u5b58\u4fee\u6539");
        this.deleteB = new JButton("\u6e05\u9664\u6240\u6709\u8a18\u9304");
        this.rearrangeB = new JButton("\u7f6e\u653e\u6700\u524d");
        RecordList list_item = this.g_Items.copy();
        list_item.sort("list_item");
        this.memberNV = new AutoComboBoxNV((ArrayList)list_item, "list_item", "member_seq", -1);
        TableLayout t = new TableLayout(this, 600, 570, 5, 10);
        int[] nArray = new int[5];
        nArray[0] = 80;
        nArray[1] = 120;
        nArray[2] = 100;
        nArray[3] = 100;
        t.getClass();
        nArray[4] = 0;
        t.addTable(nArray, new int[]{15, 15, 15, 15});
        JLabel jLabel = new JLabel("");
        t.getClass();
        t.getClass();
        t.addCell(jLabel, 0, 0, 1, 0);
        JLabel jLabel2 = new JLabel("");
        t.getClass();
        t.getClass();
        t.addCell(jLabel2, 1, 0, 20, 0, 100, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.deleteB, 4, 0, 1, 15, 100, -1);
        JLabel jLabel3 = new JLabel("\u805a\u6703\u985e\u5225:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel3, 0, 1, 1, 0);
        JLabel jLabel4 = new JLabel(MasterCode.getName(this.g_Activity.getType()));
        t.getClass();
        t.addCell(jLabel4, 1, 1, 20, 0);
        JLabel jLabel5 = new JLabel("\u805a\u6703\u540d\u7a31:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel5, 0, 2, 1, 0);
        JLabel jLabel6 = new JLabel(this.g_Activity.getName());
        t.getClass();
        t.getClass();
        t.addCell(jLabel6, 1, 2, 20, 0, 140, -1);
        JLabel jLabel7 = new JLabel("\u5730\u9ede:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel7, 2, 2, 1, 0);
        JLabel jLabel8 = new JLabel(new Venue(this.g_Activity.getVenue_seq()).getName());
        t.getClass();
        t.getClass();
        t.addCell(jLabel8, 3, 2, 20, 0, 140, -1);
        JLabel jLabel9 = new JLabel("\u65e5\u671f:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel9, 0, 3, 1, 0);
        JLabel jLabel10 = new JLabel(TimeUtil.getStringByDate(this.g_Activity.getDate()));
        t.getClass();
        t.addCell(jLabel10, 1, 3, 20, 0);
        JLabel jLabel11 = new JLabel("\u8b1b\u54e1:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel11, 2, 3, 1, 0);
        JLabel jLabel12 = new JLabel(this.g_Activity.getLecturer());
        t.getClass();
        t.getClass();
        t.addCell(jLabel12, 3, 3, 20, 0, 140, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.saveB, 4, 3, 1, 20, 80, -1);
        int[] nArray2 = new int[6];
        nArray2[0] = 80;
        nArray2[1] = 50;
        nArray2[2] = 100;
        nArray2[3] = 50;
        nArray2[4] = 100;
        t.getClass();
        nArray2[5] = 0;
        t.addTable(nArray2, new int[]{15, 15});
        JLabel jLabel13 = new JLabel("\u805a\u6703\u958b\u59cb\u6642\u9593:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel13, 0, 0, 1, 0);
        JLabel jLabel14 = new JLabel(TimeUtil.getStringByTime(this.g_Activity.getStart_time()));
        t.getClass();
        t.addCell(jLabel14, 1, 0, 20, 0);
        JLabel jLabel15 = new JLabel("\u805a\u6703\u7d50\u675f\u6642\u9593:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel15, 2, 0, 1, 0);
        JLabel jLabel16 = new JLabel(TimeUtil.getStringByTime(this.g_Activity.getEnd_time()));
        t.getClass();
        t.addCell(jLabel16, 3, 0, 20, 0);
        JLabel jLabel17 = new JLabel("\u9072\u5230\u6642\u9593:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel17, 4, 0, 1, 0);
        JLabel jLabel18 = new JLabel(TimeUtil.getStringByTime(this.g_Activity.getLate_time()));
        t.getClass();
        t.addCell(jLabel18, 5, 0, 20, 0);
        JLabel jLabel19 = new JLabel("\u958b\u59cb\u9ede\u5230\u6642\u9593:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel19, 0, 1, 1, 0);
        JLabel jLabel20 = new JLabel(TimeUtil.getStringByTime(this.g_Activity.getStart_record_time()));
        t.getClass();
        t.addCell(jLabel20, 1, 1, 20, 0);
        JLabel jLabel21 = new JLabel("\u7d50\u675f\u9ede\u5230\u6642\u9593:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel21, 2, 1, 1, 0);
        JLabel jLabel22 = new JLabel(TimeUtil.getStringByTime(this.g_Activity.getEnd_record_time()));
        t.getClass();
        t.addCell(jLabel22, 3, 1, 20, 0);
        int[] nArray3 = new int[2];
        nArray3[0] = 80;
        t.getClass();
        nArray3[1] = 0;
        t.addTable(nArray3, new int[]{15});
        JLabel jLabel23 = new JLabel("\u5099\u8a3b:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel23, 0, 0, 1, 0);
        JLabel jLabel24 = new JLabel(this.g_Activity.getRemark());
        t.getClass();
        t.getClass();
        t.addCell(jLabel24, 1, 0, 20, 0, 360, -1);
        int total_attendance = 0;
        int total_late = 0;
        int i = 0;
        while (i < this.g_Items.size()) {
            Timestamp in_time = this.g_Items.getT(Attendance.IN_TIME, i);
            if (in_time != null) {
                ++total_attendance;
                if (!in_time.before(this.g_Activity.getLate_time())) {
                    ++total_late;
                }
            }
            ++i;
        }
        int[] nArray4 = new int[5];
        nArray4[0] = 80;
        nArray4[1] = 100;
        nArray4[2] = 80;
        nArray4[3] = 100;
        t.getClass();
        nArray4[4] = 0;
        t.addTable(nArray4, new int[]{25, 25});
        JLabel jLabel25 = new JLabel("\u51fa\u5e2d\u4eba\u6578:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel25, 0, 0, 1, 0);
        JLabel jLabel26 = new JLabel(new Integer(total_attendance).toString());
        t.getClass();
        t.getClass();
        t.addCell(jLabel26, 1, 0, 20, 0, 360, -1);
        JLabel jLabel27 = new JLabel("\u9072\u5230\u4eba\u6578:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel27, 2, 0, 1, 0);
        JLabel jLabel28 = new JLabel(new Integer(total_late).toString());
        t.getClass();
        t.getClass();
        t.addCell(jLabel28, 3, 0, 20, 0, 360, -1);
        t.getClass();
        t.getClass();
        t.addCell(this.exitB, 4, 0, 1, 0, 80, -1);
        JLabel jLabel29 = new JLabel("\u6703\u773e:");
        t.getClass();
        t.getClass();
        t.addCell(jLabel29, 0, 1, 1, 0);
        t.getClass();
        t.getClass();
        t.addCell(this.memberNV, 1, 1, 20, 0, 275, -1);
        t.addCell(this.rearrangeB, 3, 1, 130, 0);
        boolean[] blArray = new boolean[5];
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        this.itemSL = new ScrollList(560, 230, this.g_Items, new int[]{125, 80, 70, 45, 235}, new String[]{"\u6703\u773e\u7de8\u865f", "\u59d3\u540d(\u4e2d\u6587)", "\u51fa\u5e2d\u6642\u9593", "\u8c41\u514d", "\u5099\u8a3b"}, new String[]{"member_id", "name_chi", "in_time", "exempt", "remark"}, blArray);
        this.itemSL.setEditing_mode(true);
        this.itemSL.setTimeTextFieldColumn(Attendance.IN_TIME, this.g_Activity.getDate());
        this.itemSL.setCheckBoxYNColumn(Attendance.EXEMPT, "Y", "N");
        t.addYSpace(10);
        int[] nArray5 = new int[1];
        t.getClass();
        nArray5[0] = 0;
        t.addTable(nArray5, new int[]{230});
        t.getClass();
        t.getClass();
        t.addCell(this.itemSL, 0, 0, -1, -1);
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.groupSL = new ScrollList2(560, 100, this.g_Amgs, new int[]{275, 80}, new String[]{"\u6703\u773e\u7fa4\u7d44", "\u984d\u5916\u51fa\u5e2d\u4eba\u6b21"}, new String[]{"name", ActivityMemberGroup.HEADCOUNT}, blArray2);
        this.groupSL.setEditing_mode(true);
        this.groupSL.setIntegerTextFieldColumn(ActivityMemberGroup.HEADCOUNT);
        t.addYSpace(10);
        int[] nArray6 = new int[1];
        t.getClass();
        nArray6[0] = 0;
        t.addTable(nArray6, new int[]{100});
        t.getClass();
        t.getClass();
        t.addCell(this.groupSL, 0, 0, -1, -1);
    }

    public void setEventHandler() {
        this.rearrangeB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceListDialog.this.onChangeMember(evt);
            }
        });
        this.saveB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceListDialog.this.onSave(evt);
            }
        });
        this.deleteB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceListDialog.this.onDelete(evt);
            }
        });
        this.exitB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttendanceListDialog.this.onExit(evt);
            }
        });
    }

    private void onChangeMember(ActionEvent evt) {
        ArrayList members = this.memberNV.getItems();
        int member_seq = ArrayUtil.getInt("MEMBER_SEQ", this.memberNV.getSelectedIndex(), members);
        int i = 0;
        while (i < this.g_Items.size()) {
            int seq = ArrayUtil.getInt("MEMBER_SEQ", i, this.g_Items);
            if (seq == member_seq) {
                HashMap h = (HashMap)this.g_Items.get(i);
                this.g_Items.remove(i);
                this.g_Items.add(0, h);
                this.itemSL.fireDataChanged();
            }
            ++i;
        }
    }

    public void onExit(ActionEvent evt) {
        this.dispose();
    }

    public void onSave(ActionEvent evt) {
        Validation validation = new Validation();
        int i = 0;
        while (i < this.g_Items.size()) {
            this.g_Items.setCurrentRow(i);
            String member_id = this.g_Items.getS("member_id");
            Timestamp in_time = this.g_Items.getT("in_time");
            String exempt = this.g_Items.getS("exempt");
            String remark = this.g_Items.getS("remark");
            if (exempt.equals("Y") && remark.equals("")) {
                validation.add(false, "\u8c41\u514d" + member_id + "\u5fc5\u9808\u586b\u5beb\u5099\u8a3b", "RT");
            }
            if (in_time != null) {
                if (exempt.equals("Y") && !in_time.after(this.g_Activity.getLate_time())) {
                    validation.add(false, "\u8c41\u514d" + member_id + "\u7684\u6642\u9593\u5fc5\u9808\u5f8c\u65bc\u9072\u5230\u6642\u9593", "RT");
                }
                if (in_time.after(this.g_Activity.getEnd_record_time())) {
                    validation.add(false, String.valueOf(member_id) + "\u7684\u51fa\u5e2d\u6642\u9593\u4e0d\u53ef\u5f8c\u65bc\u7d50\u675f\u9ede\u5230\u6642\u9593", "RT");
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.g_Amgs.size()) {
            validation.add(this.g_Amgs.getI(ActivityMemberGroup.HEADCOUNT, i), String.valueOf(this.g_Amgs.getS("name", i)) + "\u7684\u984d\u5916\u51fa\u5e2d\u4eba\u6b21\u5fc5\u9808\u662f\u6b63\u6574\u6578", "R,I,GEZ");
            ++i;
        }
        if (!validation.isValid()) {
            return;
        }
        DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
        Attendance.update(this.g_Activity_seq, this.g_Items, this.g_Amgs);
        wait_dialog.dispose();
        this.dispose();
    }

    public void onDelete(ActionEvent evt) {
        if (WinUtil.getConfirm(this, "\u8b66\u544a: \u6e05\u9664\u4e86\u7684\u8a18\u9304\u5c07\u7121\u6cd5\u5fa9\u539f, \u662f\u5426\u78ba\u5b9a\u57f7\u884c?")) {
            DataDialog wait_dialog = WinUtil.getWaitingDialog(this, "\u8cc7\u6599\u8655\u7406\u4e2d, \u8acb\u7b49\u5019...", 0.5);
            Attendance.delete(this.g_Activity_seq, null);
            Attendance.deleteHeadCount(this.g_Activity_seq, null);
            wait_dialog.dispose();
            this.dispose();
        }
    }
}

