/*
 * Decompiled with CFR 0.152.
 */
package snaq.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;

public class LogUtil {
    protected DateFormat dateFormat;
    protected DateFormat ddf;
    protected PrintStream log;
    protected boolean logging = false;
    protected boolean debug = false;

    public LogUtil() {
    }

    public LogUtil(File file) throws FileNotFoundException {
        this.setLog(new FileOutputStream(file, true));
    }

    public synchronized void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public synchronized void setLog(OutputStream outputStream) {
        if (this.log != null) {
            this.close();
        }
        if (outputStream != null) {
            this.log = new PrintStream(outputStream);
        }
        this.logging = true;
    }

    public synchronized void setLog(PrintStream printStream) {
        if (this.log != null) {
            this.close();
        }
        this.log = printStream;
        this.logging = true;
    }

    public PrintStream getLogStream() {
        return this.log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void log(String string, String string2) {
        if (!this.logging) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.dateFormat != null) {
            stringBuffer.append(this.dateFormat.format(new Date()));
        } else {
            if (this.ddf == null) {
                this.ddf = DateFormat.getDateTimeInstance(1, 1);
            }
            stringBuffer.append(this.ddf.format(new Date()));
        }
        stringBuffer.append(": ");
        if (string != null) {
            stringBuffer.append(string);
        }
        stringBuffer.append(string2);
        if (this.log != null) {
            PrintStream printStream = this.log;
            synchronized (printStream) {
                this.log.println(stringBuffer.toString());
            }
        }
    }

    public void log(String string) {
        this.log("", string);
    }

    public void log(Throwable throwable, String string, String string2) {
        if (!this.logging) {
            return;
        }
        this.log(string, string2);
        throwable.printStackTrace(this.log);
        this.log.flush();
    }

    public void log(Throwable throwable, String string) {
        this.log(throwable, "", string);
    }

    public void log(Throwable throwable) {
        this.log(throwable, throwable.getMessage());
    }

    public synchronized void close() {
        this.logging = false;
        if (this.log != null) {
            this.log.flush();
            if (!this.isSystemLog()) {
                this.log.close();
            }
        }
        this.log = null;
    }

    private boolean isSystemLog() {
        return !this.log.equals(System.out) && !this.log.equals(System.err);
    }

    public void setLogging(boolean bl) {
        this.logging = bl;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public boolean isDebug() {
        return this.debug;
    }
}

