/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.lib.FileUtil;

public class SimpleLog {
    public static final int LOG_NONE = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_NORMAL = 2;
    public static final int LOG_DETAIL = 3;
    public static final String logTypeNameEngine = "ENGINE";
    public static final String[] logTypeNames = new String[]{"", "ERROR ", "NORMAL", "DETAIL"};
    private PrintWriter writer;
    private int level;
    private boolean isSystem;
    private String filePath;

    public SimpleLog(String string, int n) {
        this.isSystem = string == null;
        this.filePath = string;
        this.setLevel(n);
    }

    private void setupWriter() {
        if (this.level == 0) {
            this.close();
            return;
        }
        if (this.writer == null) {
            if (this.isSystem) {
                this.writer = new PrintWriter(System.out);
            } else {
                File file = new File(this.filePath);
                this.setupLog(file);
            }
        }
    }

    private void setupLog(File file) {
        try {
            FileUtil.getFileUtil().makeParentDirectories(file);
            this.writer = new PrintWriter((Writer)new FileWriter(file.getPath(), true), true);
        }
        catch (Exception exception) {
            this.isSystem = true;
            this.writer = new PrintWriter(System.out);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
        this.setupWriter();
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public synchronized void logContext(int n, String string) {
        if (this.level < n) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(HsqlDateTime.getSytemTimeString()).append(' ');
        stringBuffer.append(logTypeNames[n]).append(' ').append(string);
        this.writer.println(stringBuffer.toString());
    }

    public synchronized void logContext(Throwable throwable, String string, int n) {
        if (this.level == 0) {
            return;
        }
        if (this.writer == null) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(HsqlDateTime.getSytemTimeString()).append(' ');
        stringBuffer.append(logTypeNames[n]).append(' ').append(string);
        Throwable throwable2 = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
        if (stackTraceElementArray.length > 1) {
            stringBuffer.append(stackTraceElementArray[1].getClassName()).append('.');
            stringBuffer.append(stackTraceElementArray[1].getMethodName());
        }
        if ((stackTraceElementArray = throwable.getStackTrace()).length > 0) {
            stringBuffer.append(stackTraceElementArray[0].getClassName()).append('.');
            stringBuffer.append(' ').append(stackTraceElementArray[0].getMethodName());
        }
        stringBuffer.append(' ').append(throwable.toString());
        this.writer.println(stringBuffer.toString());
    }

    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void close() {
        if (this.writer != null && !this.isSystem) {
            this.writer.close();
        }
        this.writer = null;
    }
}

