/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.StatementDML;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.LongValueHashMap;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;

public final class StatementManager {
    private Database database;
    private IntKeyHashMap schemaMap;
    private LongKeyHashMap csidMap;
    private long next_cs_id;

    StatementManager(Database database) {
        this.database = database;
        this.schemaMap = new IntKeyHashMap();
        this.csidMap = new LongKeyHashMap();
        this.next_cs_id = 0L;
    }

    synchronized void reset() {
        this.schemaMap.clear();
        this.csidMap.clear();
        this.next_cs_id = 0L;
    }

    private long nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    private long getStatementID(HsqlNameManager.HsqlName hsqlName, String string) {
        LongValueHashMap longValueHashMap = (LongValueHashMap)this.schemaMap.get(hsqlName.hashCode());
        if (longValueHashMap == null) {
            return -1L;
        }
        return longValueHashMap.get((Object)string, -1);
    }

    public synchronized Statement getStatement(Session session, long l) {
        Statement statement = (Statement)this.csidMap.get(l);
        if (statement == null) {
            return null;
        }
        if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            if ((statement = this.recompileStatement(session, statement)) == null) {
                this.freeStatement(l);
                return null;
            }
            this.csidMap.put(l, statement);
        }
        return statement;
    }

    public synchronized Statement getStatement(Session session, Statement statement) {
        long l = statement.getID();
        Statement statement2 = (Statement)this.csidMap.get(l);
        if (statement2 != null) {
            return this.getStatement(session, l);
        }
        if (statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp() && (statement2 = this.recompileStatement(session, statement)) == null) {
            this.freeStatement(l);
            return null;
        }
        return statement2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement recompileStatement(Session session, Statement statement) {
        Statement statement2;
        HsqlNameManager.HsqlName hsqlName = session.getCurrentSchemaHsqlName();
        try {
            HsqlNameManager.HsqlName hsqlName2 = statement.getSchemaName();
            session.setSchema(hsqlName2.name);
            boolean bl = statement.generatedResultMetaData() != null;
            statement2 = session.compileStatement(statement.getSQL(), statement.getResultProperties());
            if (!statement.getResultMetaData().areTypesCompatible(statement2.getResultMetaData())) {
                Statement statement3 = null;
                return statement3;
            }
            if (!statement.getParametersMetaData().areTypesCompatible(statement2.getParametersMetaData())) {
                Statement statement4 = null;
                return statement4;
            }
            ResultMetaData resultMetaData = statement2.getResultMetaData();
            statement2.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
            if (bl) {
                StatementDML statementDML = (StatementDML)statement;
                statement2.setGeneratedColumnInfo(statementDML.generatedType, statementDML.generatedInputMetaData);
            }
        }
        catch (Throwable throwable) {
            Statement statement5 = null;
            return statement5;
        }
        finally {
            session.setCurrentSchemaHsqlName(hsqlName);
        }
        return statement2;
    }

    private long registerStatement(long l, Statement statement) {
        if (l < 0L) {
            l = this.nextID();
            int n = statement.getSchemaName().hashCode();
            LongValueHashMap longValueHashMap = (LongValueHashMap)this.schemaMap.get(n);
            if (longValueHashMap == null) {
                longValueHashMap = new LongValueHashMap();
                this.schemaMap.put(n, longValueHashMap);
            }
            longValueHashMap.put(statement.getSQL(), l);
        }
        statement.setID(l);
        statement.setCompileTimestamp(this.database.txManager.getGlobalChangeTimestamp());
        this.csidMap.put(l, statement);
        return l;
    }

    synchronized void freeStatement(long l) {
        if (l == -1L) {
            return;
        }
        Statement statement = (Statement)this.csidMap.remove(l);
        if (statement != null) {
            int n = statement.getSchemaName().hashCode();
            LongValueHashMap longValueHashMap = (LongValueHashMap)this.schemaMap.get(n);
            String string = statement.getSQL();
            longValueHashMap.remove(string);
        }
    }

    synchronized Statement compile(Session session, Result result) throws Throwable {
        String string = result.getMainString();
        long l = this.getStatementID(session.currentSchema, string);
        Statement statement = (Statement)this.csidMap.get(l);
        if (statement == null || !statement.isValid() || statement.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
            int n = result.getExecuteProperties();
            statement = session.compileStatement(string, n);
            l = this.registerStatement(l, statement);
        }
        statement.setGeneratedColumnInfo(result.getGeneratedResultType(), result.getGeneratedResultMetaData());
        return statement;
    }
}

