/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDocument;
import java.util.ArrayList;

public class MultiColumnText
implements Element {
    public static final float AUTOMATIC = -1.0f;
    private float desiredHeight;
    private float totalHeight;
    private boolean overflow;
    private float top;
    private float pageBottom;
    private ColumnText columnText;
    private ArrayList columnDefs = new ArrayList();
    private boolean simple = true;

    public MultiColumnText() {
        this(-1.0f);
    }

    public MultiColumnText(float height) {
        this.desiredHeight = height;
        this.top = -1.0f;
        this.columnText = new ColumnText(null);
        this.totalHeight = 0.0f;
        this.overflow = false;
    }

    public boolean isOverflow() {
        return this.overflow;
    }

    public void useColumnParams(ColumnText sourceColumn) {
        this.columnText.setSimpleVars(sourceColumn);
    }

    public void addColumn(float[] left, float[] right) {
        ColumnDef nextDef = new ColumnDef(left, right);
        this.simple = nextDef.isSimple();
        this.columnDefs.add(nextDef);
    }

    public void addSimpleColumn(float left, float right) {
        ColumnDef newCol = new ColumnDef(left, right);
        this.columnDefs.add(newCol);
    }

    public void addRegularColumns(float left, float right, float gutterWidth, int numColumns) {
        float currX = left;
        float width = right - left;
        float colWidth = (width - gutterWidth * (float)(numColumns - 1)) / (float)numColumns;
        for (int i = 0; i < numColumns; ++i) {
            this.addSimpleColumn(currX, currX + colWidth);
            currX += colWidth + gutterWidth;
        }
    }

    public void addElement(Element element) throws DocumentException {
        if (this.simple) {
            this.columnText.addElement(element);
        } else if (element instanceof Phrase) {
            this.columnText.addText((Phrase)element);
        } else if (element instanceof Chunk) {
            this.columnText.addText((Chunk)element);
        } else {
            throw new DocumentException("Can't add " + element.getClass() + " to MultiColumnText with complex columns");
        }
    }

    public float write(PdfContentByte canvas, PdfDocument document, float documentY) throws DocumentException {
        this.columnText.canvas = canvas;
        if (this.top == -1.0f) {
            this.top = documentY;
        }
        if (this.columnDefs.size() == 0) {
            throw new DocumentException("MultiColumnText has no columns");
        }
        this.columnText.setYLine(this.top);
        this.pageBottom = document.bottom();
        float currentHeight = 0.0f;
        int currentColumn = 0;
        boolean done = false;
        try {
            while (!done) {
                ColumnDef currentDef = (ColumnDef)this.columnDefs.get(currentColumn);
                this.columnText.setYLine(this.top);
                float[] left = currentDef.resolvePositions(4);
                float[] right = currentDef.resolvePositions(8);
                currentHeight = Math.max(currentHeight, this.getHeight(left, right));
                if (currentDef.isSimple()) {
                    this.columnText.setSimpleColumn(left[2], left[3], right[0], right[1]);
                } else {
                    this.columnText.setColumns(left, right);
                }
                int result = this.columnText.go();
                if ((result & 1) != 0) {
                    done = true;
                    continue;
                }
                if (currentColumn + 1 < this.columnDefs.size()) {
                    ++currentColumn;
                    continue;
                }
                this.totalHeight += currentHeight;
                if (this.desiredHeight != -1.0f && this.totalHeight >= this.desiredHeight) {
                    done = true;
                    this.overflow = true;
                    continue;
                }
                document.newPage();
                currentColumn = 0;
                this.top = document.top();
                currentHeight = 0.0f;
            }
        }
        catch (DocumentException ex) {
            ex.printStackTrace();
            throw ex;
        }
        return currentHeight;
    }

    private float getHeight(float[] left, float[] right) {
        int i;
        float max = Float.MIN_VALUE;
        float min = Float.MAX_VALUE;
        for (i = 0; i < left.length; i += 2) {
            min = Math.min(min, left[i + 1]);
            max = Math.max(max, left[i + 1]);
        }
        for (i = 0; i < right.length; i += 2) {
            min = Math.min(min, right[i + 1]);
            max = Math.max(max, right[i + 1]);
        }
        return max - min;
    }

    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    public int type() {
        return 40;
    }

    public ArrayList getChunks() {
        return null;
    }

    private float getColumnBottom() {
        if (this.desiredHeight == -1.0f) {
            return this.pageBottom;
        }
        return Math.max(this.top - (this.desiredHeight - this.totalHeight), this.pageBottom);
    }

    private class ColumnDef {
        private float[] left;
        private float[] right;

        ColumnDef(float[] newLeft, float[] newRight) {
            this.left = newLeft;
            this.right = newRight;
        }

        ColumnDef(float leftPosition, float rightPosition) {
            this.left = new float[4];
            this.left[0] = leftPosition;
            this.left[1] = MultiColumnText.this.top;
            this.left[2] = leftPosition;
            this.left[3] = MultiColumnText.this.desiredHeight == -1.0f || MultiColumnText.this.top == -1.0f ? -1.0f : MultiColumnText.this.top - MultiColumnText.this.desiredHeight;
            this.right = new float[4];
            this.right[0] = rightPosition;
            this.right[1] = MultiColumnText.this.top;
            this.right[2] = rightPosition;
            this.right[3] = MultiColumnText.this.desiredHeight == -1.0f || MultiColumnText.this.top == -1.0f ? -1.0f : MultiColumnText.this.top - MultiColumnText.this.desiredHeight;
        }

        float[] resolvePositions(int side) {
            if (side == 4) {
                return this.resolvePositions(this.left);
            }
            return this.resolvePositions(this.right);
        }

        private float[] resolvePositions(float[] positions) {
            if (!this.isSimple()) {
                return positions;
            }
            if (MultiColumnText.this.top == -1.0f) {
                throw new RuntimeException("resolvePositions called with top=AUTOMATIC (-1).  Top position must be set befure lines can be resolved");
            }
            positions[1] = MultiColumnText.this.top;
            positions[3] = MultiColumnText.this.getColumnBottom();
            return positions;
        }

        private boolean isSimple() {
            return this.left.length == 4 && this.right.length == 4 && this.left[0] == this.left[2] && this.right[0] == this.right[2];
        }
    }
}

