/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.msgpack.template.builder.JavassistTemplateBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplatePrecompiler {
    private static final Logger LOG = LoggerFactory.getLogger(TemplatePrecompiler.class);
    public static final String DEST = "msgpack.template.destdir";
    public static final String DEFAULT_DEST = ".";

    public static void saveTemplates(String[] classNames) throws IOException, ClassNotFoundException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String className : classNames) {
            TemplatePrecompiler.matchClassNames(ret, className);
        }
        List<Class<?>> ret0 = TemplatePrecompiler.toClass(ret);
        for (Class<?> c : ret0) {
            TemplatePrecompiler.saveTemplateClass(c);
        }
    }

    private static void matchClassNames(List<String> ret, String className) throws IOException {
        String packageName = className.substring(0, className.lastIndexOf(46));
        String relativedName = className.substring(className.lastIndexOf(46) + 1, className.length());
        String patName = relativedName.replace("*", "(\\w+)");
        Pattern pat = Pattern.compile(patName);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fm = compiler.getStandardFileManager(new DiagnosticCollector(), null, null);
        HashSet<JavaFileObject.Kind> kind = new HashSet<JavaFileObject.Kind>(){
            {
                this.add(JavaFileObject.Kind.CLASS);
            }
        };
        for (JavaFileObject f : fm.list(StandardLocation.PLATFORM_CLASS_PATH, packageName, (Set<JavaFileObject.Kind>)kind, false)) {
            String name;
            String relatived0 = f.getName();
            String name0 = relatived0.substring(0, relatived0.length() - ".class".length());
            Matcher m = pat.matcher(name0);
            if (!m.matches() || ret.contains(name = packageName + '.' + name0)) continue;
            ret.add(name);
        }
    }

    private static List<Class<?>> toClass(List<String> classNames) throws ClassNotFoundException {
        ArrayList ret = new ArrayList(classNames.size());
        ClassLoader cl = TemplatePrecompiler.class.getClassLoader();
        for (String className : classNames) {
            Class<?> c = cl.loadClass(className);
            ret.add(c);
        }
        return ret;
    }

    public static void saveTemplateClasses(Class<?>[] targetClasses) throws IOException {
        for (Class<?> c : targetClasses) {
            TemplatePrecompiler.saveTemplateClass(c);
        }
    }

    public static void saveTemplateClass(Class<?> targetClass) throws IOException {
        LOG.info("Saving template of " + targetClass.getName() + "...");
        Properties props = System.getProperties();
        String distDirName = TemplatePrecompiler.getDirName(props, DEST, DEFAULT_DEST);
        if (targetClass.isEnum()) {
            throw new UnsupportedOperationException("Not supported enum type yet: " + targetClass.getName());
        }
        new JavassistTemplateBuilder().writeTemplate(targetClass, distDirName);
        LOG.info("Saved .class file of template class of " + targetClass.getName());
    }

    private static String getDirName(Properties props, String dirName, String defaultDirName) throws IOException {
        String dName = props.getProperty(dirName, defaultDirName);
        File d = new File(dName);
        if (!d.isDirectory() && !d.exists()) {
            throw new IOException("Directory not exists: " + dName);
        }
        return d.getAbsolutePath();
    }

    public static void main(String[] args) throws Exception {
        TemplatePrecompiler.saveTemplates(args);
    }
}

