/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.lang.reflect.Type;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.msgpack.AbstractTemplate;
import org.msgpack.Template;
import org.msgpack.template.FieldEntryReader;
import org.msgpack.template.FieldOption;
import org.msgpack.template.IFieldEntry;
import org.msgpack.template.IFieldEntryReader;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.BuildContext;
import org.msgpack.template.builder.BuildContextBase;
import org.msgpack.template.builder.BuildContextFactory;
import org.msgpack.template.builder.CustomTemplateBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistTemplateBuilder
extends CustomTemplateBuilder {
    private static Logger LOG = LoggerFactory.getLogger(JavassistTemplateBuilder.class);
    private static JavassistTemplateBuilder instance;
    IFieldEntryReader reader = new FieldEntryReader();
    BuildContextFactory buildContextFactory = new BuildContextFactory(){

        public BuildContextBase createBuildContext(JavassistTemplateBuilder builder) {
            return new BuildContext(builder);
        }
    };
    protected ClassPool pool = new ClassPool();
    private int seqId = 0;

    public static synchronized JavassistTemplateBuilder getInstance() {
        if (instance == null) {
            instance = new JavassistTemplateBuilder();
        }
        return instance;
    }

    public static void addClassLoader(ClassLoader cl) {
        JavassistTemplateBuilder.getInstance().pool.appendClassPath((ClassPath)new LoaderClassPath(cl));
    }

    public void setFieldEntryReader(IFieldEntryReader reader) {
        this.reader = reader;
    }

    public void setBuildContextFactory(BuildContextFactory factory) {
        this.buildContextFactory = factory;
    }

    public JavassistTemplateBuilder() {
        boolean appended = false;
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
            if (cl != null) {
                this.pool.appendClassPath((ClassPath)new LoaderClassPath(cl));
                appended = true;
            }
        }
        catch (SecurityException e) {
            LOG.debug("Cannot append a search path of context classloader", (Throwable)e);
        }
        try {
            ClassLoader cl2 = this.getClass().getClassLoader();
            if (cl2 != null && cl2 != cl) {
                this.pool.appendClassPath((ClassPath)new LoaderClassPath(cl2));
                appended = true;
            }
        }
        catch (SecurityException e) {
            LOG.debug("Cannot append a search path of classloader", (Throwable)e);
        }
        if (!appended) {
            this.pool.appendSystemPath();
        }
    }

    public JavassistTemplateBuilder(IFieldEntryReader reader, BuildContextFactory buildContextFactory) {
        this();
        this.reader = reader;
        this.buildContextFactory = buildContextFactory;
    }

    public CtClass makeCtClass(String className) {
        return this.pool.makeClass(className);
    }

    public CtClass getCtClass(String className) throws NotFoundException {
        return this.pool.get(className);
    }

    public int nextSeqId() {
        return this.seqId++;
    }

    @Override
    public Template buildTemplate(Class<?> targetClass, IFieldEntry[] entries) {
        Template[] tmpls = JavassistTemplateBuilder.toTemplate(entries);
        BuildContextBase bc = this.getBuildContextFacotry().createBuildContext(this);
        return bc.buildTemplate(targetClass, entries, tmpls);
    }

    private static Template[] toTemplate(IFieldEntry[] from) {
        Template[] tmpls = new Template[from.length];
        for (int i = 0; i < from.length; ++i) {
            Template tmpl;
            IFieldEntry e = from[i];
            tmpls[i] = !e.isAvailable() ? null : (tmpl = TemplateRegistry.lookup(e.getGenericType(), true));
        }
        return tmpls;
    }

    @Override
    public IFieldEntryReader getFieldEntryReader() {
        return this.reader;
    }

    public BuildContextFactory getBuildContextFacotry() {
        return this.buildContextFactory;
    }

    @Override
    public void writeTemplate(Type targetType, String directoryName) {
        Class targetClass = (Class)targetType;
        IFieldEntryReader reader = this.getFieldEntryReader();
        FieldOption implicitOption = reader.readImplicitFieldOption(targetClass);
        this.checkValidation(targetClass);
        IFieldEntry[] entries = reader.readFieldEntries(targetClass, implicitOption);
        this.writeTemplate(targetClass, entries, directoryName);
    }

    private void writeTemplate(Class<?> targetClass, IFieldEntry[] entries, String directoryName) {
        Template[] tmpls = JavassistTemplateBuilder.toTemplate(entries);
        BuildContextBase bc = this.getBuildContextFacotry().createBuildContext(this);
        bc.writeTemplate(targetClass, entries, tmpls, directoryName);
    }

    @Override
    public Template loadTemplate(Type targetType) {
        Class targetClass = (Class)targetType;
        IFieldEntryReader reader = this.getFieldEntryReader();
        FieldOption implicitOption = reader.readImplicitFieldOption(targetClass);
        this.checkValidation(targetClass);
        IFieldEntry[] entries = reader.readFieldEntries(targetClass, implicitOption);
        return this.loadTemplate(targetClass, entries);
    }

    private Template loadTemplate(Class<?> targetClass, IFieldEntry[] entries) {
        Template[] tmpls = JavassistTemplateBuilder.toTemplate(entries);
        BuildContextBase bc = this.getBuildContextFacotry().createBuildContext(this);
        return bc.loadTemplate(targetClass, entries, tmpls);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class JavassistTemplate
    extends AbstractTemplate {
        public Class<?> targetClass;
        public Template[] templates;

        public JavassistTemplate(Class<?> targetClass, Template[] templates) {
            this.targetClass = targetClass;
            this.templates = templates;
        }
    }
}

