/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template.builder;

import java.io.IOException;
import org.msgpack.AbstractTemplate;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.BeansFieldEntry;
import org.msgpack.template.BeansFieldEntryReader;
import org.msgpack.template.IFieldEntry;
import org.msgpack.template.IFieldEntryReader;
import org.msgpack.template.TemplateRegistry;
import org.msgpack.template.builder.CustomTemplateBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansTemplateBuilder
extends CustomTemplateBuilder {
    IFieldEntryReader reader = new BeansFieldEntryReader();

    @Override
    public IFieldEntryReader getFieldEntryReader() {
        return this.reader;
    }

    @Override
    public Template buildTemplate(Class<?> targetClass, IFieldEntry[] entries) {
        ReflectionEntry[] refEntries = new ReflectionEntry[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            BeansFieldEntry e = (BeansFieldEntry)entries[i];
            Class<?> type = e.getType();
            if (type.equals(Boolean.TYPE)) {
                refEntries[i] = new ReflectionEntry(e);
                continue;
            }
            if (type.equals(Byte.TYPE)) {
                refEntries[i] = new ReflectionEntry(e);
                continue;
            }
            if (type.equals(Short.TYPE)) {
                refEntries[i] = new ReflectionEntry(e);
                continue;
            }
            if (type.equals(Integer.TYPE)) {
                refEntries[i] = new ReflectionEntry(e);
                continue;
            }
            if (type.equals(Long.TYPE)) {
                refEntries[i] = new ReflectionEntry(e);
                continue;
            }
            if (type.equals(Float.TYPE)) {
                refEntries[i] = new ReflectionEntry(e);
                continue;
            }
            if (type.equals(Double.TYPE)) {
                refEntries[i] = new ReflectionEntry(e);
                continue;
            }
            Template tmpl = TemplateRegistry.lookup(e.getGenericType(), true);
            refEntries[i] = new ObjectFieldEntry(e, tmpl);
        }
        return new BeansReflectionTemplate(targetClass, refEntries);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BeansReflectionTemplate
    extends AbstractTemplate {
        Class<?> targetClass;
        ReflectionEntry[] entries = null;
        protected int minimumArrayLength;

        public BeansReflectionTemplate(Class<?> targetClass, ReflectionEntry[] entries) {
            this.targetClass = targetClass;
            this.entries = entries;
            this.minimumArrayLength = 0;
            for (int i = 0; i < entries.length; ++i) {
                ReflectionEntry e = entries[i];
                if (!e.isRequired() && !e.isNullable()) continue;
                this.minimumArrayLength = i + 1;
            }
        }

        @Override
        public void pack(Packer pk, Object target) throws IOException {
            pk.packArray(this.entries.length);
            for (ReflectionEntry e : this.entries) {
                if (!e.isAvailable()) {
                    pk.packNil();
                    continue;
                }
                Object obj = e.get(target);
                if (obj == null) {
                    if (!e.isNullable() && !e.isOptional()) {
                        throw new MessageTypeException();
                    }
                    pk.packNil();
                    continue;
                }
                pk.pack(obj);
            }
        }

        @Override
        public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
            try {
                int max;
                int i;
                int length;
                if (to == null) {
                    to = this.targetClass.newInstance();
                }
                if ((length = pac.unpackArray()) < this.minimumArrayLength) {
                    throw new MessageTypeException();
                }
                for (i = 0; i < this.minimumArrayLength; ++i) {
                    ReflectionEntry e = this.entries[i];
                    if (!e.isAvailable()) {
                        pac.unpackObject();
                        continue;
                    }
                    if (pac.tryUnpackNull()) {
                        if (e.isRequired()) {
                            throw new MessageTypeException();
                        }
                        if (e.isOptional()) continue;
                        e.setNull(to);
                        continue;
                    }
                    e.unpack(to, pac);
                }
                int n = max = length < this.entries.length ? length : this.entries.length;
                while (i < max) {
                    ReflectionEntry e = this.entries[i];
                    if (!e.isAvailable()) {
                        pac.unpackObject();
                    } else if (!pac.tryUnpackNull()) {
                        e.unpack(to, pac);
                    }
                    ++i;
                }
                while (i < length) {
                    pac.unpackObject();
                    ++i;
                }
                return to;
            }
            catch (MessageTypeException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageTypeException(e);
            }
        }

        @Override
        public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
            try {
                int max;
                int i;
                MessagePackObject[] array;
                int length;
                if (to == null) {
                    to = this.targetClass.newInstance();
                }
                if ((length = (array = from.asArray()).length) < this.minimumArrayLength) {
                    throw new MessageTypeException();
                }
                for (i = 0; i < this.minimumArrayLength; ++i) {
                    ReflectionEntry e = this.entries[i];
                    if (!e.isAvailable()) continue;
                    MessagePackObject obj = array[i];
                    if (obj.isNil()) {
                        if (e.isRequired()) {
                            throw new MessageTypeException();
                        }
                        if (e.isOptional()) continue;
                        e.setNull(to);
                        continue;
                    }
                    e.convert(to, obj);
                }
                int n = max = length < this.entries.length ? length : this.entries.length;
                while (i < max) {
                    MessagePackObject obj;
                    ReflectionEntry e = this.entries[i];
                    if (e.isAvailable() && !(obj = array[i]).isNil()) {
                        e.convert(to, obj);
                    }
                    ++i;
                }
                return to;
            }
            catch (MessageTypeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageTypeException(e);
            }
        }
    }

    static class ObjectFieldEntry
    extends ReflectionEntry {
        Template template;

        public ObjectFieldEntry(BeansFieldEntry entry, Template template) {
            super(entry);
            this.template = template;
        }

        public void pack(Object value, Packer packer) throws IOException {
            this.template.pack(packer, value);
        }

        public void convert(Object target, MessagePackObject obj) throws MessageTypeException, IllegalAccessException {
            Class<?> type = this.entry.getType();
            Object fieldReference = this.entry.get(target);
            Object valueReference = this.template.convert(obj, fieldReference);
            if (valueReference != fieldReference) {
                this.entry.set(target, valueReference);
            }
        }

        public void unpack(Object target, Unpacker unpacker) throws IOException, MessageTypeException, IllegalAccessException {
            Class<?> type = this.entry.getType();
            Object fieldReference = this.entry.get(target);
            Object valueReference = this.template.unpack(unpacker, fieldReference);
            if (valueReference != fieldReference) {
                this.entry.set(target, valueReference);
            }
        }
    }

    static class ReflectionEntry {
        BeansFieldEntry entry;

        public ReflectionEntry(BeansFieldEntry entry) {
            this.entry = entry;
        }

        public void pack(Object value, Packer packer) throws IOException {
            packer.pack(value);
        }

        public void convert(Object target, MessagePackObject obj) throws MessageTypeException, IllegalAccessException {
            this.entry.set(target, obj.convert(this.entry.getType()));
        }

        public void unpack(Object target, Unpacker unpacker) throws IOException, MessageTypeException, IllegalAccessException {
            this.entry.set(target, unpacker.unpack(this.entry.getType()));
        }

        public void setNull(Object target) {
            this.entry.set(target, null);
        }

        public boolean isRequired() {
            return this.entry.isRequired();
        }

        public boolean isNullable() {
            return this.entry.isNullable();
        }

        public boolean isAvailable() {
            return this.entry.isAvailable();
        }

        public boolean isOptional() {
            return this.entry.isOptional();
        }

        public Object get(Object target) {
            return this.entry.get(target);
        }
    }
}

