/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.Template;
import org.msgpack.template.BuiltInTemplateLoader;
import org.msgpack.template.DefaultTemplate;
import org.msgpack.template.FieldList;
import org.msgpack.template.FieldOption;
import org.msgpack.template.GenericTemplate;
import org.msgpack.template.TemplateBuildException;
import org.msgpack.template.builder.BuilderSelectorRegistry;
import org.msgpack.template.builder.CustomTemplateBuilder;
import org.msgpack.template.builder.TemplateBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRegistry {
    private static Map<Type, Template> map = new HashMap<Type, Template>();
    private static Map<Type, GenericTemplate> genericMap = new HashMap<Type, GenericTemplate>();
    private static BuilderSelectorRegistry builderSelectorRegistry;

    public static void register(Class<?> target) {
        TemplateBuilder builder = builderSelectorRegistry.select(target);
        if (builder != null) {
            TemplateRegistry.register(target, builder.buildTemplate(target));
        } else {
            TemplateRegistry.register(target, builderSelectorRegistry.getForceBuilder().buildTemplate(target));
        }
    }

    public static void register(Class<?> target, FieldOption implicitOption) {
        TemplateBuilder builder = builderSelectorRegistry.select(target);
        if (builder == null || !(builder instanceof CustomTemplateBuilder)) {
            throw new TemplateBuildException("Cannot build template with filed option");
        }
        TemplateRegistry.register(target, ((CustomTemplateBuilder)builder).buildTemplate(target, implicitOption));
    }

    public static void register(Class<?> target, FieldList flist) throws NoSuchFieldException {
        TemplateBuilder builder = builderSelectorRegistry.select(target);
        if (builder == null || !(builder instanceof CustomTemplateBuilder)) {
            throw new TemplateBuildException("Cannot build template with filed list");
        }
        TemplateRegistry.register(target, ((CustomTemplateBuilder)builder).buildTemplate(target, flist));
    }

    public static synchronized void register(Type rawType, Template tmpl) {
        if (rawType instanceof ParameterizedType) {
            rawType = ((ParameterizedType)rawType).getRawType();
        }
        map.put(rawType, tmpl);
    }

    public static boolean unregister(Class<?> target) {
        Template tmpl = map.remove(target);
        return tmpl != null;
    }

    public static synchronized void registerGeneric(Type rawType, GenericTemplate gtmpl) {
        if (rawType instanceof ParameterizedType) {
            rawType = ((ParameterizedType)rawType).getRawType();
        }
        genericMap.put(rawType, gtmpl);
    }

    public static synchronized Template lookup(Type targetType) {
        return TemplateRegistry.lookupImpl(targetType, true, false, true);
    }

    public static synchronized Template lookup(Type targetType, boolean forceBuild) {
        return TemplateRegistry.lookupImpl(targetType, true, forceBuild, true);
    }

    public static synchronized Template lookup(Type targetType, boolean forceLoad, boolean forceBuild) {
        return TemplateRegistry.lookupImpl(targetType, forceLoad, forceBuild, true);
    }

    public static synchronized Template tryLookup(Type targetType) {
        return TemplateRegistry.lookupImpl(targetType, true, false, false);
    }

    public static synchronized Template tryLookup(Type targetType, boolean forceBuild) {
        return TemplateRegistry.lookupImpl(targetType, true, forceBuild, false);
    }

    private static synchronized Template lookupImpl(Type targetType, boolean forceLoad, boolean forceBuild, boolean fallbackDefault) {
        Template tmpl;
        if (targetType instanceof ParameterizedType) {
            tmpl = TemplateRegistry.lookupGenericImpl((ParameterizedType)targetType);
            if (tmpl != null) {
                return tmpl;
            }
            targetType = ((ParameterizedType)targetType).getRawType();
        }
        if ((tmpl = map.get(targetType)) != null) {
            return tmpl;
        }
        TemplateBuilder builder = BuilderSelectorRegistry.getInstance().select(targetType);
        if (builder != null) {
            if (forceLoad && (tmpl = builder.loadTemplate(targetType)) != null) {
                TemplateRegistry.register(targetType, tmpl);
                return tmpl;
            }
            tmpl = builder.buildTemplate(targetType);
            if (tmpl != null) {
                TemplateRegistry.register(targetType, tmpl);
                return tmpl;
            }
        }
        Class target = (Class)targetType;
        for (Class<?> i : target.getInterfaces()) {
            tmpl = map.get(i);
            if (tmpl == null) continue;
            TemplateRegistry.register((Type)target, tmpl);
            return tmpl;
        }
        Class c = target.getSuperclass();
        if (c != null) {
            while (c != Object.class) {
                tmpl = map.get(c);
                if (tmpl != null) {
                    TemplateRegistry.register((Type)target, tmpl);
                    return tmpl;
                }
                c = c.getSuperclass();
            }
            if (forceBuild) {
                tmpl = builderSelectorRegistry.getForceBuilder().buildTemplate(target);
                TemplateRegistry.register((Type)target, tmpl);
                return tmpl;
            }
        }
        if (fallbackDefault) {
            tmpl = new DefaultTemplate(target);
            TemplateRegistry.register((Type)target, tmpl);
            return tmpl;
        }
        return null;
    }

    public static synchronized Template lookupGeneric(Type targetType) {
        if (targetType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)targetType;
            Template tmpl = TemplateRegistry.lookupGenericImpl(parameterizedType);
            if (tmpl != null) {
                return tmpl;
            }
            return new DefaultTemplate((Class)parameterizedType.getRawType(), parameterizedType);
        }
        throw new IllegalArgumentException("Actual types of the generic type are erased: " + targetType);
    }

    private static synchronized Template lookupGenericImpl(ParameterizedType type) {
        Type rawType = type.getRawType();
        GenericTemplate gtmpl = genericMap.get(rawType);
        if (gtmpl == null) {
            return null;
        }
        Type[] types = type.getActualTypeArguments();
        Template[] tmpls = new Template[types.length];
        for (int i = 0; i < types.length; ++i) {
            tmpls[i] = TemplateRegistry.lookup(types[i]);
        }
        return gtmpl.build(tmpls);
    }

    static {
        BuiltInTemplateLoader.load();
        builderSelectorRegistry = BuilderSelectorRegistry.getInstance();
    }
}

