/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class StringTemplate
implements Template {
    static final StringTemplate instance = new StringTemplate();

    private StringTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        try {
            pk.packString((String)target);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        return pac.unpackString();
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        return from.asString();
    }

    public static StringTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(String.class, instance);
    }
}

