/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class ShortArrayTemplate
implements Template {
    static final ShortArrayTemplate instance = new ShortArrayTemplate();

    private ShortArrayTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        if (!(target instanceof short[])) {
            throw new MessageTypeException();
        }
        short[] array = (short[])target;
        try {
            pk.packArray(array.length);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
        for (short a : array) {
            pk.pack(a);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        int length = pac.unpackArray();
        short[] array = to != null && to instanceof short[] && ((short[])to).length == length ? (short[])to : new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = pac.unpackShort();
        }
        return array;
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        MessagePackObject[] src = from.asArray();
        short[] array = to != null && to instanceof short[] && ((short[])to).length == src.length ? (short[])to : new short[src.length];
        for (int i = 0; i < src.length; ++i) {
            MessagePackObject s = src[i];
            array[i] = s.asShort();
        }
        return array;
    }

    public static ShortArrayTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(short[].class, instance);
    }
}

