/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.AnyTemplate;
import org.msgpack.template.GenericTemplate2;
import org.msgpack.template.TemplateRegistry;

public class MapTemplate
implements Template {
    private Template keyTemplate;
    private Template valueTemplate;

    static void load() {
    }

    public MapTemplate(Template keyTemplate, Template valueTemplate) {
        this.keyTemplate = keyTemplate;
        this.valueTemplate = valueTemplate;
    }

    public Template getKeyTemplate() {
        return this.keyTemplate;
    }

    public Template getValueTemplate() {
        return this.valueTemplate;
    }

    public void pack(Packer pk, Object target) throws IOException {
        if (!(target instanceof Map)) {
            if (target == null) {
                throw new MessageTypeException(new NullPointerException("target is null."));
            }
            throw new MessageTypeException("target is not Map type: " + target.getClass());
        }
        Map map = (Map)target;
        pk.packMap(map.size());
        for (Map.Entry pair : map.entrySet()) {
            this.keyTemplate.pack(pk, pair.getKey());
            this.valueTemplate.pack(pk, pair.getValue());
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        HashMap<Object, Object> map;
        int length = pac.unpackMap();
        if (to == null) {
            map = new HashMap<Object, Object>(length);
        } else {
            map = (HashMap<Object, Object>)to;
            map.clear();
        }
        while (length > 0) {
            Object key = this.keyTemplate.unpack(pac, null);
            Object value = this.valueTemplate.unpack(pac, null);
            map.put(key, value);
            --length;
        }
        return map;
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        HashMap<Object, Object> map;
        Map<MessagePackObject, MessagePackObject> src = from.asMap();
        if (to == null) {
            map = new HashMap<Object, Object>(src.size());
        } else {
            map = (HashMap<Object, Object>)to;
            map.clear();
        }
        for (Map.Entry<MessagePackObject, MessagePackObject> pair : src.entrySet()) {
            Object key = this.keyTemplate.convert(pair.getKey(), null);
            Object value = this.valueTemplate.convert(pair.getValue(), null);
            map.put(key, value);
        }
        return map;
    }

    static {
        TemplateRegistry.registerGeneric(Map.class, new GenericTemplate2(MapTemplate.class));
        TemplateRegistry.register(Map.class, new MapTemplate(AnyTemplate.getInstance(), AnyTemplate.getInstance()));
    }
}

