/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class IntegerTemplate
implements Template {
    static final IntegerTemplate instance = new IntegerTemplate();

    private IntegerTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        try {
            pk.packInt((Integer)target);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        return pac.unpackInt();
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        return from.asInt();
    }

    public static IntegerTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(Integer.class, instance);
        TemplateRegistry.register(Integer.TYPE, instance);
    }
}

