/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class IntArrayTemplate
implements Template {
    static final IntArrayTemplate instance = new IntArrayTemplate();

    private IntArrayTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        if (!(target instanceof int[])) {
            throw new MessageTypeException();
        }
        int[] array = (int[])target;
        try {
            pk.packArray(array.length);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
        for (int a : array) {
            pk.pack(a);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        int length = pac.unpackArray();
        int[] array = to != null && to instanceof int[] && ((int[])to).length == length ? (int[])to : new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = pac.unpackInt();
        }
        return array;
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        MessagePackObject[] src = from.asArray();
        int[] array = to != null && to instanceof int[] && ((int[])to).length == src.length ? (int[])to : new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            MessagePackObject s = src[i];
            array[i] = s.asInt();
        }
        return array;
    }

    public static IntArrayTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(int[].class, instance);
    }
}

