/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class FloatArrayTemplate
implements Template {
    static final FloatArrayTemplate instance = new FloatArrayTemplate();

    private FloatArrayTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        if (!(target instanceof float[])) {
            throw new MessageTypeException();
        }
        float[] array = (float[])target;
        try {
            pk.packArray(array.length);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
        for (float a : array) {
            pk.pack(a);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        int length = pac.unpackArray();
        float[] array = to != null && to instanceof float[] && ((float[])to).length == length ? (float[])to : new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = pac.unpackFloat();
        }
        return array;
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        MessagePackObject[] src = from.asArray();
        float[] array = to != null && to instanceof float[] && ((float[])to).length == src.length ? (float[])to : new float[src.length];
        for (int i = 0; i < src.length; ++i) {
            MessagePackObject s = src[i];
            array[i] = s.asFloat();
        }
        return array;
    }

    public static FloatArrayTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(float[].class, instance);
    }
}

