/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.annotation.Ignore;
import org.msgpack.annotation.Index;
import org.msgpack.annotation.MessagePackMessage;
import org.msgpack.annotation.Nullable;
import org.msgpack.annotation.Optional;
import org.msgpack.annotation.Required;
import org.msgpack.template.FieldEntry;
import org.msgpack.template.FieldList;
import org.msgpack.template.FieldOption;
import org.msgpack.template.IFieldEntry;
import org.msgpack.template.IFieldEntryReader;
import org.msgpack.template.TemplateBuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldEntryReader
implements IFieldEntryReader {
    @Override
    public IFieldEntry[] convertFieldEntries(Class<?> targetClass, FieldList flist) throws NoSuchFieldException {
        List<FieldList.Entry> src = flist.getList();
        IFieldEntry[] result = new FieldEntry[src.size()];
        for (int i = 0; i < src.size(); ++i) {
            FieldList.Entry s = src.get(i);
            result[i] = s.isAvailable() ? new FieldEntry(targetClass.getDeclaredField(s.getName()), s.getOption()) : new FieldEntry();
        }
        return result;
    }

    @Override
    public IFieldEntry[] readFieldEntries(Class<?> targetClass, FieldOption implicitOption) {
        Field[] allFields = this.readAllFields(targetClass);
        ArrayList<FieldEntry> indexed = new ArrayList<FieldEntry>();
        int maxIndex = -1;
        for (Field f : allFields) {
            FieldOption opt = FieldEntryReader.readFieldOption(f, implicitOption);
            if (opt == FieldOption.IGNORE) continue;
            int index = FieldEntryReader.readFieldIndex(f, maxIndex);
            if (indexed.size() > index && indexed.get(index) != null) {
                throw new TemplateBuildException("duplicated index: " + index);
            }
            if (index < 0) {
                throw new TemplateBuildException("invalid index: " + index);
            }
            while (indexed.size() <= index) {
                indexed.add(null);
            }
            indexed.set(index, new FieldEntry(f, opt));
            if (maxIndex >= index) continue;
            maxIndex = index;
        }
        IFieldEntry[] result = new FieldEntry[maxIndex + 1];
        for (int i = 0; i < indexed.size(); ++i) {
            FieldEntry e = (FieldEntry)indexed.get(i);
            result[i] = e == null ? new FieldEntry() : e;
        }
        return result;
    }

    @Override
    public FieldOption readImplicitFieldOption(Class<?> targetClass) {
        MessagePackMessage a = targetClass.getAnnotation(MessagePackMessage.class);
        if (a == null) {
            return FieldOption.DEFAULT;
        }
        return a.value();
    }

    private Field[] readAllFields(Class<?> targetClass) {
        ArrayList<Field[]> succ = new ArrayList<Field[]>();
        int total = 0;
        for (Class<?> c = targetClass; c != Object.class; c = c.getSuperclass()) {
            Field[] fields = c.getDeclaredFields();
            total += fields.length;
            succ.add(fields);
        }
        Field[] result = new Field[total];
        int off = 0;
        for (int i = succ.size() - 1; i >= 0; --i) {
            Field[] fields = (Field[])succ.get(i);
            System.arraycopy(fields, 0, result, off, fields.length);
            off += fields.length;
        }
        return result;
    }

    private static FieldOption readFieldOption(Field field, FieldOption implicitOption) {
        int mod = field.getModifiers();
        if (Modifier.isStatic(mod) || Modifier.isFinal(mod)) {
            return FieldOption.IGNORE;
        }
        if (FieldEntryReader.isAnnotated(field, Ignore.class)) {
            return FieldOption.IGNORE;
        }
        if (FieldEntryReader.isAnnotated(field, Required.class)) {
            return FieldOption.REQUIRED;
        }
        if (FieldEntryReader.isAnnotated(field, Optional.class)) {
            return FieldOption.OPTIONAL;
        }
        if (FieldEntryReader.isAnnotated(field, Nullable.class)) {
            if (field.getDeclaringClass().isPrimitive()) {
                return FieldOption.REQUIRED;
            }
            return FieldOption.NULLABLE;
        }
        if (implicitOption != FieldOption.DEFAULT) {
            return implicitOption;
        }
        if (Modifier.isTransient(mod)) {
            return FieldOption.IGNORE;
        }
        if (Modifier.isPublic(mod)) {
            return FieldOption.REQUIRED;
        }
        return FieldOption.IGNORE;
    }

    private static int readFieldIndex(Field field, int maxIndex) {
        Index a = field.getAnnotation(Index.class);
        if (a == null) {
            return maxIndex + 1;
        }
        return a.value();
    }

    private static boolean isAnnotated(AccessibleObject ao, Class<? extends Annotation> with) {
        return ao.getAnnotation(with) != null;
    }
}

