/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class DoubleTemplate
implements Template {
    static final DoubleTemplate instance = new DoubleTemplate();

    private DoubleTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        try {
            pk.packDouble((Double)target);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        return pac.unpackDouble();
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        return from.asDouble();
    }

    public static DoubleTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(Double.class, instance);
        TemplateRegistry.register(Double.TYPE, instance);
    }
}

