/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class DoubleArrayTemplate
implements Template {
    static final DoubleArrayTemplate instance = new DoubleArrayTemplate();

    private DoubleArrayTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        if (!(target instanceof double[])) {
            throw new MessageTypeException();
        }
        double[] array = (double[])target;
        try {
            pk.packArray(array.length);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
        for (double a : array) {
            pk.pack(a);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        int length = pac.unpackArray();
        double[] array = to != null && to instanceof double[] && ((double[])to).length == length ? (double[])to : new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = pac.unpackDouble();
        }
        return array;
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        MessagePackObject[] src = from.asArray();
        double[] array = to != null && to instanceof double[] && ((double[])to).length == src.length ? (double[])to : new double[src.length];
        for (int i = 0; i < src.length; ++i) {
            MessagePackObject s = src[i];
            array[i] = s.asDouble();
        }
        return array;
    }

    public static DoubleArrayTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(double[].class, instance);
    }
}

