/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class ByteArrayTemplate
implements Template {
    static final ByteArrayTemplate instance = new ByteArrayTemplate();

    private ByteArrayTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        try {
            pk.packByteArray((byte[])target);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        return pac.unpackByteArray();
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        return from.asByteArray();
    }

    public static ByteArrayTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(byte[].class, instance);
    }
}

