/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import java.math.BigInteger;
import org.msgpack.MessagePackObject;
import org.msgpack.MessageTypeException;
import org.msgpack.Packer;
import org.msgpack.Template;
import org.msgpack.Unpacker;
import org.msgpack.template.TemplateRegistry;

public class BigIntegerTemplate
implements Template {
    static final BigIntegerTemplate instance = new BigIntegerTemplate();

    private BigIntegerTemplate() {
    }

    public void pack(Packer pk, Object target) throws IOException {
        try {
            pk.packBigInteger((BigInteger)target);
        }
        catch (NullPointerException e) {
            throw new MessageTypeException("target is null.", e);
        }
    }

    public Object unpack(Unpacker pac, Object to) throws IOException, MessageTypeException {
        return pac.unpackBigInteger();
    }

    public Object convert(MessagePackObject from, Object to) throws MessageTypeException {
        return from.asBigInteger();
    }

    public static BigIntegerTemplate getInstance() {
        return instance;
    }

    static {
        TemplateRegistry.register(BigInteger.class, instance);
    }
}

